package pl.shockah.ts.entities.effects;

import pl.shockah.Math2;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.state.State;
import pl.shockah.ts.Assets;
import pl.shockah.ts.gameplay.Game;

public class EffectOverlayTime extends EntityRenderable {
	public static EffectOverlayTime me = null;
	
	protected double xx = 0;
	public float musicPitch = 1, a1 = 0, a2 = 0;
	
	public EffectOverlayTime() {
		baseDepth = -100000;
	}
	
	protected void onCreate() {
		me = this;
	}
	
	protected void onUpdate() {
		switch (Game.me.time) {
			case Normal: {
				if (musicPitch < 1f) {
					if (musicPitch >= 0f) {
						a1 -= .05f;
						a2 -= .05f;
					}
					musicPitch += .05f;
				}
			} break;
			case Slow: {
				if (musicPitch < .5f) {
					musicPitch += .05f;
					if (musicPitch >= 0f) {
						a1 += .05f;
						a2 -= .05f;
					}
				}
				if (musicPitch > 0.5f) {
					musicPitch -= .05f;
					a1 += .05f;
					a2 -= .05f;
				}
			} break;
			case Stop: {
				if (musicPitch < 0f) musicPitch += .05f; else {
					musicPitch -= .05f;
					musicPitch = Math.max(musicPitch,0f);
					a1 -= .05f;
					a2 += .05f;
				}
			} break;
		}
		
		a1 = Math2.limit(a1,0f,.5f);
		a2 = Math2.limit(a2,0f,.5f);
		
		if (musicPitch >= .5f) xx += 2f; else xx += musicPitch*4f;
		if (xx < 0f) xx += Assets.sOverlayTime.getTextureWidth();
		if (xx > Assets.sOverlayTime.getTextureWidth()) xx -= Assets.sOverlayTime.getTextureWidth();
	}
	
	protected void onRender(Graphics g) {
		Vector2i size = State.get().getDisplaySize();
		
		g.toggleAbsolute();
		GL.translated(Game.me.translateV.Negate());
		if (a1 > 0) {
			g.setColor(Color.Purple.alpha(a1));
			for (int y = 0; y < size.y; y += Assets.sOverlayTime.getTextureHeight())
			for (int x = (int)(xx-Assets.sOverlayTime.getTextureWidth()); x < size.x; x += Assets.sOverlayTime.getTextureWidth()) {
				g.draw(Assets.sOverlayTime,x,y);
			}
		}
		if (a2 > 0) {
			g.setColor(Color.White.alpha(a2));
			for (int y = 0; y < size.y; y += Assets.sOverlayTime.getTextureHeight())
			for (int x = (int)(xx-Assets.sOverlayTime.getTextureWidth()); x < size.x; x += Assets.sOverlayTime.getTextureWidth()) {
				g.draw(Assets.sOverlayTime,x,y);
			}
		}
		GL.translated(Game.me.translateV);
		g.toggleAbsolute();
	}
}