package pl.shockah.ts.entities;

import pl.shockah.Math2;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.Circle;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.font.ETextAlign;
import pl.shockah.glib.gl.font.TextHelper;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;

public class EntityWallHint extends EntityWall {
	public static String globalMessage = null;
	public static float alpha = 0f;
	
	protected final String message;
	protected float ratio = 0f;
	
	public EntityWallHint(String message) {
		this.message = message;
	}
	
	protected void onUpdate() {
		boolean col = collidesAt(Entities.getType(EntityPlayer.class).get(0),pos.x,pos.y-1);
		ratio = Math2.limit(ratio+(col ? .1f : -.1f),0f,1f);
		if (message.equals(globalMessage)) {
			alpha = Math2.limit(alpha+(col ? .1f : -.1f),0f,1f);
			if (alpha <= 0f) globalMessage = null;
		} else if (globalMessage == null && col) globalMessage = message;
	}
	
	protected void onRegister() {
		super.onRegister();
		
		new Renderable(this,0d-.4d){
			protected void onRender(Graphics g) {
				g.setColor(Color.Black.interpolate(Color.White,ratio,Interpolate.Linear).alpha(.5f));
				g.draw(new Circle(pos.x+12,pos.y+12,8).asPolygon(16));
				
				GL.setThickness(2);
				g.setColor(Color.White.interpolate(Color.Black,ratio,Interpolate.Linear).alpha(.5f));
				g.draw(new Circle(pos.x+12,pos.y+12,9).asPolygon(16),false);
				GL.setThickness(1);
			}
		}.create();
		
		new Renderable(this,0d-.5d){
			protected void onRender(Graphics g) {
				g.setColor(Color.Black);
				for (int yy = -1; yy <= 1; yy += 2) for (int xx = -1; xx <= 1; xx += 2) TextHelper.draw(g,Assets.font16,pos.x+12+xx,pos.y+3+yy,"?",ETextAlign.TopCenter);
				g.setColor(Color.White);
				TextHelper.draw(g,Assets.font16,pos.x+12,pos.y+3,"?",ETextAlign.TopCenter);
			}
		}.create();
	}
}