package pl.shockah.ts.entities;

import pl.shockah.Util;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;

public class EntityBoxFading extends EntityBox {
	protected float fading = -1;
	protected float alpha = 1f;
	
	protected void onCreate() {
		super.onCreate();
		shape = new Rectangle(pos.x,pos.y,24,24);
	}
	
	protected void onUpdate() {
		double mod = Game.me.time.getSpeed(this);
		if (mod == 0) return;
		
		if (fading == -1 && collidesAt(Util.getAllOf(Entities.getTypes(EntityPlayer.class,EntityBoxGravity.class),EntityCollidable.class),pos.x,pos.y-1)) fading = 10;
		if (fading > 0) fading -= 1*mod;
		if (fading <= 0 && fading > -1) {
			alpha -= .05f*mod;
			if (alpha <= 0f) destroy();
		}
	}
	
	protected void onRegister() {
		new Renderable(this,baseDepth-.1d){
			protected void onRender(Graphics g) {
				Color c1 = Color.White.alpha((alpha*2f)*WaterBlur.blurAlpha), c2 = Color.White.alpha(alpha*WaterBlur.blurAlpha);
				Assets.ssBoxes.getImage(0).drawTextureMulticolor(g,pos,c1,c1,c2,c2);
			}
		}.create();
		
		new Renderable(this,baseDepth-.2d){
			protected void onRender(Graphics g) {
				Color c1 = Color.White.alpha((alpha*2f)*WaterBlur.blurAlpha), c2 = Color.White.alpha(alpha*WaterBlur.blurAlpha);
				Assets.ssTileBorderThin.getImage(0).drawTextureMulticolor(g,pos,c1,c1,c2,c2);
			}
		}.create();
	}
}