/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.particles;

import pl.shockah.glib.animfx.Animation;
import pl.shockah.glib.animfx.TimelineObject;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.particle.Particle;
import pl.shockah.glib.particle.ParticleSystem;
import pl.shockah.glib.particle.ParticleType;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;

public class PtSkidJump
extends ParticleType {
    protected static final ParticleType pt = new PtSkidJump();

    public static void make(ParticleSystem ps, Vector2d pos) {
        pt.spawn(ps, pos, new Object[0]);
    }

    public PtSkidJump() {
        super(Assets.ptFuzzy);
    }

    @Override
    public Particle create(ParticleSystem ps, IVector2 pos, Object ... args) {
        CustomParticle cp = new CustomParticle(ps, this);
        cp.size.set(3.0, 8.0);
        cp.pos = pos.toDouble();
        cp.vel = Vector2d.make(0.3 + Main.rand.nextDouble() * 0.2, Main.rand.nextDouble() * 360.0);
        cp.rotation = Main.rand.nextDouble() * 360.0;
        return cp;
    }

    @Override
    protected void onUpdate(Particle p) {
        super.onUpdate(p);
        CustomParticle cp = (CustomParticle)p;
        cp.anim.update();
        if (cp.anim.isFinished()) {
            cp.dead = true;
        }
    }

    @Override
    protected void onRender(Particle p, Graphics g) {
        CustomParticle cp = (CustomParticle)p;
        g.setColor((Color)cp.tlColor.getState(cp.anim));
        this.image.scale = p.size.Div(this.image.getSize().toDouble());
        this.image.rotation.angle = p.rotation;
        g.draw((ITextureSupplier)this.image, (IVector2)p.pos);
        this.image.rotation.angle = p.rotation + 90.0;
        g.draw((ITextureSupplier)this.image, (IVector2)p.pos);
        this.image.rotation.angle = 0.0;
        this.image.scale.set(1.0, 1.0);
    }

    protected class CustomParticle
    extends Particle {
        protected final Animation anim;
        protected final TimelineObject<Color> tlColor;

        public CustomParticle(ParticleSystem ps, ParticleType pt) {
            super(ps, pt);
            this.anim = new Animation();
            this.tlColor = new TimelineObject();
            this.tlColor.add(Color.Yellow, 0.0);
            this.tlColor.copyLast(30.0);
            this.tlColor.add(Color.Yellow.alpha(0.0f), 40.0);
            this.anim.add(this.tlColor);
        }
    }
}

