/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.particles;

import pl.shockah.glib.animfx.Animation;
import pl.shockah.glib.animfx.TimelineObject;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.color.Colorf;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.particle.Particle;
import pl.shockah.glib.particle.ParticleSystem;
import pl.shockah.glib.particle.ParticleType;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;

public class PtLand
extends ParticleType {
    protected static final ParticleType pt = new PtLand();

    public static void make(ParticleSystem ps, Vector2d pos, Object ... args) {
        pt.spawn(ps, pos, args);
    }

    public PtLand() {
        super(Assets.ptFuzzy);
    }

    @Override
    public Particle create(ParticleSystem ps, IVector2 pos, Object ... args) {
        CustomParticle cp = new CustomParticle(ps, this);
        cp.size.set(6.0, 6.0);
        cp.pos = pos.toDouble();
        if (args.length == 0 || args.length == 1 && args[0] instanceof Boolean) {
            boolean b = args.length == 0 ? Main.rand.nextBoolean() : ((Boolean)args[0]).booleanValue();
            cp.pos.x = cp.pos.x + (double)(b ? 10 : -10);
            cp.vel = Vector2d.make((0.3 + Main.rand.nextDouble() * 0.2) * 5.0, Main.rand.nextDouble() * 30.0 + (b ? 0.0 : 150.0));
        } else if (args.length == 1 && args[0] instanceof Number) {
            Number n = (Number)args[0];
            cp.vel = Vector2d.make((0.3 + Main.rand.nextDouble() * 0.2) * 5.0, n.doubleValue() - 15.0 + Main.rand.nextDouble() * 30.0);
        }
        return cp;
    }

    @Override
    protected void onUpdate(Particle p) {
        super.onUpdate(p);
        CustomParticle cp = (CustomParticle)p;
        cp.anim.update();
        if (cp.anim.isFinished()) {
            cp.dead = true;
        }
    }

    @Override
    protected void onRender(Particle p, Graphics g) {
        CustomParticle cp = (CustomParticle)p;
        g.setColor((Color)cp.tlColor.getState(cp.anim));
        this.image.scale = p.size.Div(this.image.getSize().toDouble());
        this.image.rotation.angle = p.rotation;
        g.draw((ITextureSupplier)this.image, (IVector2)p.pos);
        this.image.rotation.angle = p.rotation + 90.0;
        g.draw((ITextureSupplier)this.image, (IVector2)p.pos);
        this.image.rotation.angle = 0.0;
        this.image.scale.set(1.0, 1.0);
    }

    protected class CustomParticle
    extends Particle {
        protected final Animation anim;
        protected final TimelineObject<Color> tlColor;

        public CustomParticle(ParticleSystem ps, ParticleType pt) {
            super(ps, pt);
            this.anim = new Animation();
            this.tlColor = new TimelineObject();
            Colorf c = new Colorf(0.9f, 0.9f, 0.9f);
            this.tlColor.add(c, 0.0);
            this.tlColor.copyLast(6.0);
            this.tlColor.add(c.alpha(0.0f), 12.0);
            this.anim.add(this.tlColor);
        }
    }
}

