/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities.waterblur;

import pl.shockah.glib.geom.Line;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.polygon.Polygon;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.Stencil;
import pl.shockah.glib.gl.StencilMask;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;

public class EffectWater
extends EntityRenderable {
    private double sin = 0.0;

    public EffectWater() {
        this.baseDepth = -10001.0;
    }

    @Override
    protected void onUpdate() {
        this.sin += Game.me.time.getSpeed() / 60.0;
    }

    @Override
    protected void onRender(Graphics g) {
        StencilMask sm = new StencilMask(g, Stencil.Keep).proceed();
        int x = 0;
        while (x < Game.me.tileSize.x) {
            int y = 0;
            while (y < Game.me.tileSize.y) {
                if (Game.me.water[x][y]) {
                    this.drawWater(g, x, y, Color.White, Color.White);
                }
                ++y;
            }
            ++x;
        }
        sm.proceed();
        WaterBlur.render(g);
        sm.proceed();
        Color cWater = Color.DarkCyan.alpha(0.5f);
        Color cWaterLine = Color.Black;
        GL.setThickness(2.0f);
        int x2 = 0;
        while (x2 < Game.me.tileSize.x) {
            int y = 0;
            while (y < Game.me.tileSize.y) {
                if (Game.me.water[x2][y]) {
                    this.drawWater(g, x2, y, cWater, cWaterLine);
                }
                ++y;
            }
            ++x2;
        }
        GL.setThickness(1.0f);
    }

    protected void drawWater(Graphics g, int x, int y, Color cWater, Color cWaterLine) {
        double sx = x * 24;
        double sy = y * 24;
        boolean U = y > 0 && Game.me.water[x][y - 1];
        g.setColor(cWater);
        if (U) {
            g.draw(new Rectangle(x * 24, y * 24, 24.0, 24.0));
        } else {
            Polygon p = new Polygon();
            Polygon p2 = new Polygon();
            int i = 0;
            while (i <= 12) {
                double yy = sy + 5.0 + Math.sin(Math.toRadians(sx + (double)(i * 2) + this.sin * 45.0) * 4.0) * 1.5;
                p.addPoint(sx + (double)(i * 2), yy);
                p2.addPoint(sx + (double)(i * 2), yy + 1.0);
                ++i;
            }
            p.addPoint(sx + 24.0, sy + 24.0);
            p.addPoint(sx, sy + 24.0);
            g.draw(p);
            g.setColor(cWaterLine);
            Line[] lineArray = p2.getLines(false);
            int n = lineArray.length;
            int n2 = 0;
            while (n2 < n) {
                Line line = lineArray[n2];
                g.draw(line);
                ++n2;
            }
        }
    }
}

