/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import java.util.List;
import pl.shockah.Util;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityBase;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.ts.entities.EntityBox;
import pl.shockah.ts.entities.EntityWall;
import pl.shockah.ts.entities.IGravity;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;

public class EntityBoxGravity
extends EntityBox
implements IGravity {
    public Vector2d toMove = new Vector2d();
    public Vector2d vel = new Vector2d();

    protected double getYAcceleration(boolean water) {
        return 0.5 * (double)(water ? 0.6666667f : 1.0f);
    }

    protected double getYVelocityLimit() {
        return 12.0;
    }

    @Override
    protected void onUpdate() {
        boolean v;
        List<EntityCollidable> platforms = Util.getAllOf(this.getPlatforms(), EntityCollidable.class);
        boolean collidesD = this.collidesAt(platforms, this.pos.x, this.pos.y + 1.0);
        boolean inWater = WaterBlur.isInWater(this);
        if (!collidesD) {
            double fallSpeed = this.getYAcceleration(inWater);
            double limit = this.getYVelocityLimit();
            if (this.vel.y < limit) {
                this.vel.y += fallSpeed;
            }
            if (this.vel.y > limit) {
                this.vel.y -= fallSpeed;
                if (this.vel.y < limit) {
                    this.vel.y = limit;
                }
            }
        }
        this.toMove.add(new Vector2d(inWater ? this.vel.x / 4.0 : this.vel.x, inWater ? this.vel.y / 4.0 : this.vel.y).scale(Game.me.time.getSpeed(this)));
        do {
            v = false;
            if (!(this.toMove.y >= 0.5) && !(this.toMove.y < -0.5)) continue;
            v = true;
            int sign2 = (int)Math.signum(this.toMove.y);
            if (!this.collidesAt(platforms, this.pos.x, this.pos.y + (double)sign2)) {
                this.pos.y += (double)sign2;
                this.toMove.y -= (double)sign2;
                continue;
            }
            this.toMove.y = 0.0;
            this.vel.y = 0.0;
        } while (v);
    }

    protected List<EntityBase> getPlatforms() {
        return Entities.getTypes(EntityWall.class, EntityBox.class);
    }
}

