/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.state;

import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.state.ETransition;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.transitions.Transition;

public final class TransitionState {
    public final State state;
    public final Transition tOut;
    public final Transition tIn;
    public ETransition trans = ETransition.Out;

    public TransitionState(State state, Transition tOut, Transition tIn) {
        this.state = state;
        this.tOut = tOut;
        this.tIn = tIn;
    }

    public Transition getCurrent() {
        switch (this.trans) {
            case Out: {
                return this.tOut;
            }
            case In: {
                return this.tIn;
            }
        }
        return null;
    }

    public void init() {
        Transition current = this.getCurrent();
        if (current == null) {
            return;
        }
        current.init(this.trans == ETransition.In);
    }

    public boolean shouldUpdate() {
        Transition current = this.getCurrent();
        if (current == null) {
            return true;
        }
        return current.shouldUpdate();
    }

    public boolean shouldRender(Graphics g) {
        Transition current = this.getCurrent();
        if (current == null) {
            return true;
        }
        return current.shouldRender(g);
    }

    public boolean update() {
        Transition current = this.getCurrent();
        if (current == null || current.update()) {
            switch (this.trans) {
                case Out: {
                    this.trans = ETransition.In;
                    State.set(this.state);
                    if (this.tIn == null) {
                        this.trans = ETransition.None;
                        return true;
                    }
                    this.init();
                    break;
                }
                case In: {
                    this.trans = ETransition.None;
                    return true;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    public void render(Graphics g) {
        Transition current = this.getCurrent();
        if (current == null) {
            return;
        }
        current.render(g);
    }

    public void preRender(Graphics g) {
        Transition current = this.getCurrent();
        if (current == null) {
            return;
        }
        current.preRender(g);
    }
}

