/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.state;

import java.util.LinkedList;
import java.util.List;
import pl.shockah.glib.Gamelib;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.state.TransitionState;
import pl.shockah.glib.state.View;
import pl.shockah.glib.state.transitions.Transition;

public class State {
    protected static State current;
    protected static TransitionState transitionState;
    protected List<View> views = new LinkedList<View>();
    protected int fps = 60;

    public static State get() {
        return current;
    }

    public static void change(State state) {
        State.change(state, null, null);
    }

    public static void change(State state, Transition transition) {
        State.change(state, transition, transition);
    }

    public static void change(State state, Transition out, Transition in) {
        if (transitionState != null) {
            return;
        }
        if (current == null) {
            current = state;
            return;
        }
        transitionState = new TransitionState(state, out, in);
        transitionState.init();
    }

    static void set(State state) {
        current = state;
        if (current != null) {
            Gamelib.game.reset();
            current.create();
        } else {
            Gamelib.stop();
        }
    }

    public final void updateTransition() {
        if (transitionState == null) {
            return;
        }
        if (transitionState.update()) {
            transitionState = null;
        }
    }

    public final void renderTransition(Graphics g) {
        if (transitionState == null) {
            return;
        }
        transitionState.render(g);
    }

    public final void renderTransitionPre(Graphics g) {
        if (transitionState == null) {
            return;
        }
        transitionState.preRender(g);
    }

    public final boolean shouldTransitionUpdate() {
        if (transitionState == null) {
            return true;
        }
        return transitionState.shouldUpdate();
    }

    public final boolean shouldTransitionRender(Graphics g) {
        if (transitionState == null) {
            return true;
        }
        return transitionState.shouldRender(g);
    }

    public final Vector2i getDisplaySize() {
        int w = 0;
        int h = 0;
        for (View view : this.views) {
            int xx = view.portPos.x + view.portSize.x;
            int yy = view.portPos.y + view.portSize.y;
            if (xx > w) {
                w = xx;
            }
            if (yy <= h) continue;
            h = yy;
        }
        return new Vector2i(w, h);
    }

    public final int getFPS() {
        if (this.fps < 1) {
            this.fps = 60;
        }
        return this.fps;
    }

    public final void setup() {
        this.onSetup();
        if (this.views.isEmpty()) {
            this.views.add(new View());
        }
        Gamelib.setDisplayMode(this.getDisplaySize());
    }

    protected void onSetup() {
    }

    public final void create() {
        this.onCreate();
    }

    protected void onCreate() {
    }

    public final void preUpdate() {
        this.onPreUpdate();
    }

    protected void onPreUpdate() {
    }

    public final void preRender(Graphics g) {
        this.onPreRender(g);
    }

    protected void onPreRender(Graphics g) {
    }

    public final void preTransitionRender(Graphics g) {
        this.onPreTransitionRender(g);
    }

    protected void onPreTransitionRender(Graphics g) {
    }

    public final void postRender(Graphics g) {
        this.onPostRender(g);
    }

    protected void onPostRender(Graphics g) {
    }
}

