/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.particle;

import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.particle.Particle;
import pl.shockah.glib.particle.ParticleSystem;

public abstract class ParticleType {
    protected final Image image;

    public ParticleType(Image image) {
        this.image = image;
    }

    public void spawn(ParticleSystem ps, IVector2 pos, Object ... args) {
        ps.particles.add(this.create(ps, pos, args));
    }

    protected abstract Particle create(ParticleSystem var1, IVector2 var2, Object ... var3);

    protected void onSpawn(Particle p) {
    }

    protected void onDespawn(Particle p) {
    }

    protected void onUpdate(Particle p) {
        p.pos.add(p.vel);
    }

    protected void onRender(Particle p, Graphics g) {
        this.image.rotation.angle = p.rotation;
        this.image.scale = p.size.Div(this.image.getSize());
        g.draw((ITextureSupplier)this.image, (IVector2)p.pos);
        this.image.rotation.angle = 0.0;
        this.image.scale.set(1.0, 1.0);
    }
}

