/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.BlendMode;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.GLList;
import pl.shockah.glib.gl.Surface;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.input.MInput;
import pl.shockah.glib.state.State;

public class Graphics {
    private static BlendMode defaultBlendMode = BlendMode.Normal;
    private static Color clearColor = Color.TransparentBlack;
    private static DoubleBuffer tmpTransformedClip = BufferUtils.createDoubleBuffer((int)4);
    private static Rectangle lastClip = null;
    private static Rectangle lastTransformedClip = null;
    protected static Graphics lastGraphics = null;
    protected Graphics redirect = null;
    protected List<Transformation> transformations = new ArrayList<Transformation>();
    protected List<Rectangle> clipStack = new LinkedList<Rectangle>();
    protected List<Rectangle> transformedClipStack = new LinkedList<Rectangle>();
    protected boolean absolute = false;
    protected Color color = Color.White;

    public static void setDefaultBlendMode(BlendMode bm) {
        defaultBlendMode = bm;
    }

    public static BlendMode getDefaultBlendMode() {
        return defaultBlendMode;
    }

    public final void preDraw() {
        if (this.redirect != null) {
            this.redirect.preDraw();
            return;
        }
        if (lastGraphics != null && lastGraphics != this) {
            lastGraphics.onUnbind();
        }
        this.onBind();
        if (lastGraphics != this) {
            if (GL.pushedMatrix()) {
                GL.popMatrix();
            }
            GL.pushMatrix();
            if (!this.absolute) {
                this.applyTransformations();
            }
            this.applyClip(this.clipStack.isEmpty() ? null : this.clipStack.get(this.clipStack.size() - 1));
            this.applyTransformedClip(this.transformedClipStack.isEmpty() ? null : this.transformedClipStack.get(this.transformedClipStack.size() - 1));
            GL.bind(this.color);
        }
        lastGraphics = this;
    }

    protected void onBind() {
        GL.unbindSurface();
    }

    protected void onUnbind() {
    }

    public void setColor(Color color) {
        if (this.redirect != null) {
            this.redirect.setColor(color);
            return;
        }
        this.color = color;
        if (lastGraphics == this) {
            GL.bind(color);
        }
    }

    protected void applyTransformations() {
        if (lastGraphics != this) {
            return;
        }
        for (Transformation t : this.transformations) {
            t.apply();
        }
    }

    protected void unapplyTransformations() {
        if (lastGraphics != this) {
            return;
        }
        if (GL.pushedMatrix()) {
            GL.popMatrix();
        }
        GL.pushMatrix();
    }

    public void translate(Vector2d v) {
        this.translate(v.x, v.y);
    }

    public void translate(double x, double y) {
        if (this.redirect != null) {
            this.redirect.translate(x, y);
            return;
        }
        TransformationTranslate t = new TransformationTranslate(new Vector2d(x, y));
        this.transformations.add(t);
        if (lastGraphics == this) {
            ((Transformation)t).apply();
        }
    }

    public void scale(IVector2 v) {
        this.scale(v.Xd(), v.Yd());
    }

    public void scale(double x, double y) {
        if (this.redirect != null) {
            this.redirect.scale(x, y);
            return;
        }
        TransformationScale t = new TransformationScale(new Vector2d(x, y));
        this.transformations.add(t);
        if (lastGraphics == this) {
            ((Transformation)t).apply();
        }
    }

    public int popTransformation() {
        if (this.redirect != null) {
            return this.redirect.popTransformation();
        }
        if (this.transformations.isEmpty()) {
            return 0;
        }
        this.transformations.get(this.transformations.size() - 1).unapply();
        this.transformations.remove(this.transformations.size() - 1);
        return this.transformations.size();
    }

    public void clearTransformations() {
        if (this.redirect != null) {
            this.redirect.clearTransformations();
            return;
        }
        this.unapplyTransformations();
        this.transformations.clear();
    }

    public void pushClip(Rectangle rect) {
        if (this.redirect != null) {
            this.redirect.pushClip(rect);
            return;
        }
        if (rect == null ^ this.clipStack.isEmpty() || !this.clipStack.get(this.clipStack.size() - 1).equals(rect)) {
            this.applyClip(rect);
            if (rect == null) {
                if (!this.clipStack.isEmpty()) {
                    this.clipStack.remove(this.clipStack.size() - 1);
                }
                if (!this.clipStack.isEmpty()) {
                    rect = this.clipStack.get(this.clipStack.size() - 1);
                    this.applyClip(rect);
                }
            } else {
                this.clipStack.add(rect.copyMe());
            }
        }
    }

    public void pushClip(double x, double y, double w, double h) {
        this.pushClip(new Rectangle(x, y, w, h));
    }

    public void popClip() {
        this.pushClip(null);
    }

    public void clearClip() {
        if (this.redirect != null) {
            this.redirect.clearClip();
            return;
        }
        if (this.clipStack.isEmpty()) {
            return;
        }
        this.clipStack.clear();
        if (lastGraphics != this) {
            return;
        }
        GL11.glDisable((int)3089);
    }

    protected void applyClip(Rectangle rect) {
        if (this.redirect != null) {
            this.redirect.applyClip(rect);
            return;
        }
        if (lastGraphics != this) {
            return;
        }
        if (rect == null) {
            GL11.glDisable((int)3089);
        } else {
            Rectangle newr = new Rectangle((int)rect.pos.x, (int)(GL.flipped() ? (double)State.get().getDisplaySize().y - rect.pos.y - rect.size.y : rect.pos.y), (int)rect.size.x, (int)rect.size.y);
            if (!newr.equals(lastClip)) {
                GL11.glScissor((int)newr.pos.Xi(), (int)newr.pos.Yi(), (int)newr.size.Xi(), (int)newr.size.Yi());
                lastClip = newr;
            }
            GL11.glEnable((int)3089);
        }
    }

    public void pushTransformedClip(Rectangle rect) {
        if (this.redirect != null) {
            this.redirect.pushTransformedClip(rect);
            return;
        }
        if (rect == null ^ this.transformedClipStack.isEmpty() || !this.transformedClipStack.get(this.transformedClipStack.size() - 1).equals(rect)) {
            this.applyTransformedClip(rect);
            if (rect == null) {
                if (!this.transformedClipStack.isEmpty()) {
                    this.transformedClipStack.remove(this.transformedClipStack.size() - 1);
                }
                if (!this.transformedClipStack.isEmpty()) {
                    rect = this.transformedClipStack.get(this.transformedClipStack.size() - 1);
                    this.applyTransformedClip(rect);
                }
            } else {
                this.transformedClipStack.add(rect.copyMe());
            }
        }
    }

    public void pushTransformedClip(double x, double y, double w, double h) {
        this.pushTransformedClip(new Rectangle(x, y, w, h));
    }

    public void popTransformedClip() {
        this.pushTransformedClip(null);
    }

    public void clearTransformedClip() {
        if (this.redirect != null) {
            this.redirect.clearTransformedClip();
            return;
        }
        if (this.transformedClipStack.isEmpty()) {
            return;
        }
        this.transformedClipStack.clear();
        if (lastGraphics != this) {
            return;
        }
        GL11.glDisable((int)12288);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12291);
    }

    protected void applyTransformedClip(Rectangle rect) {
        if (this.redirect != null) {
            this.redirect.applyTransformedClip(rect);
            return;
        }
        if (lastGraphics != this) {
            return;
        }
        if (rect == null) {
            GL11.glDisable((int)12288);
            GL11.glDisable((int)12289);
            GL11.glDisable((int)12290);
            GL11.glDisable((int)12291);
        } else {
            Rectangle newr = new Rectangle(rect);
            if (!newr.equals(lastTransformedClip)) {
                tmpTransformedClip.put(1.0).put(0.0).put(0.0).put(-rect.pos.x).flip();
                GL11.glClipPlane((int)12288, (DoubleBuffer)tmpTransformedClip);
                tmpTransformedClip.put(-1.0).put(0.0).put(0.0).put(rect.pos.x + rect.size.x).flip();
                GL11.glClipPlane((int)12289, (DoubleBuffer)tmpTransformedClip);
                tmpTransformedClip.put(0.0).put(1.0).put(0.0).put(-rect.pos.y).flip();
                GL11.glClipPlane((int)12290, (DoubleBuffer)tmpTransformedClip);
                tmpTransformedClip.put(0.0).put(-1.0).put(0.0).put(rect.pos.y + rect.size.y).flip();
                GL11.glClipPlane((int)12291, (DoubleBuffer)tmpTransformedClip);
                lastTransformedClip = newr;
            }
            GL11.glEnable((int)12288);
            GL11.glEnable((int)12289);
            GL11.glEnable((int)12290);
            GL11.glEnable((int)12291);
        }
    }

    public void clear() {
        if (this.redirect != null) {
            this.redirect.clear();
            return;
        }
        this.clear(Color.Black);
    }

    public void clear(Color color) {
        this.clear(color, true, false);
    }

    public void clear(Color color, boolean bitColor, boolean bitStencil) {
        if (this.redirect != null) {
            this.redirect.clear(color, bitColor, bitStencil);
            return;
        }
        this.preDraw();
        if (!color.equals(clearColor)) {
            GL11.glClearColor((float)color.Rf(), (float)color.Gf(), (float)color.Bf(), (float)color.Af());
            clearColor = color;
        }
        GL11.glClear((int)((bitColor ? 16384 : 0) | (bitStencil ? 1024 : 0)));
    }

    public final void setRedirect(Graphics g) {
        if (g == null) {
            return;
        }
        if (g.equals(this.redirect)) {
            return;
        }
        if (this.redirect == null) {
            this.redirect = g;
        } else {
            this.redirect.setRedirect(g);
        }
    }

    public final void clearRedirect() {
        if (this.redirect == null) {
            return;
        }
        if (this.redirect.redirect == null) {
            this.redirect = null;
        } else {
            this.redirect.clearRedirect();
        }
    }

    public final Graphics getRedirect() {
        return this.redirect;
    }

    public void draw(Shape shape) {
        if (this.redirect != null) {
            this.redirect.draw(shape);
            return;
        }
        shape.draw(this);
    }

    public void draw(Shape shape, boolean filled) {
        if (this.redirect != null) {
            this.redirect.draw(shape, filled);
            return;
        }
        shape.draw(this, filled);
    }

    public void draw(ITextureSupplier ts) {
        this.draw(ts, 0.0, 0.0);
    }

    public void draw(ITextureSupplier ts, IVector2 v) {
        this.draw(ts, v.Xd(), v.Yd());
    }

    public void draw(ITextureSupplier ts, double x, double y) {
        if (this.redirect != null) {
            this.redirect.draw(ts, x, y);
            return;
        }
        ts.drawTexture(this, x, y);
    }

    public void draw(Image image, double rotation) {
        this.draw(image, 0.0, 0.0, rotation);
    }

    public void draw(Image image, IVector2 v, double rotation) {
        this.draw(image, v.Xd(), v.Yd(), rotation);
    }

    public void draw(Image image, double x, double y, double rotation) {
        if (this.redirect != null) {
            this.redirect.draw(image, x, y, rotation);
            return;
        }
        double rot = image.rotation.angle;
        image.rotation.angle = rotation;
        image.drawTexture(this, x, y);
        image.rotation.angle = rot;
    }

    public void draw(Surface surface) {
        this.draw(surface, 0.0, 0.0, 0.0);
    }

    public void draw(Surface surface, double rotation) {
        this.draw(surface, 0.0, 0.0, rotation);
    }

    public void draw(Surface surface, IVector2 v) {
        this.draw(surface, v.Xd(), v.Yd(), 0.0);
    }

    public void draw(Surface surface, IVector2 v, double rotation) {
        this.draw(surface, v.Xd(), v.Yd(), rotation);
    }

    public void draw(Surface surface, double x, double y) {
        this.draw(surface, x, y, 0.0);
    }

    public void draw(Surface surface, double x, double y, double rotation) {
        if (this.redirect != null) {
            this.redirect.draw(surface, x, y, rotation);
            return;
        }
        this.draw(surface.image(), x, y, rotation);
    }

    public void draw(GLList gll) {
        this.draw(gll, 0.0, 0.0);
    }

    public void draw(GLList gll, IVector2 v) {
        this.draw(gll, v.Xd(), v.Yd());
    }

    public void draw(GLList gll, double x, double y) {
        if (this.redirect != null) {
            this.redirect.draw(gll, x, y);
            return;
        }
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)x, (double)y, (double)0.0);
        }
        GL11.glCallList((int)gll.getID());
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        }
    }

    public Vector2d getMousePos() {
        if (this.redirect != null) {
            return this.redirect.getMousePos();
        }
        return MInput.getPos().toDouble();
    }

    public void drawAbsolute() {
        if (this.redirect != null) {
            this.redirect.drawAbsolute();
            return;
        }
        if (!this.absolute) {
            this.absolute = true;
            this.unapplyTransformations();
        }
    }

    public void drawTransformed() {
        if (this.redirect != null) {
            this.redirect.drawTransformed();
            return;
        }
        if (this.absolute) {
            this.absolute = false;
            this.applyTransformations();
        }
    }

    public void toggleAbsolute() {
        if (this.absolute) {
            this.drawTransformed();
        } else {
            this.drawAbsolute();
        }
    }

    public boolean drawingAbsolute() {
        if (this.redirect != null) {
            return this.redirect.drawingAbsolute();
        }
        return this.absolute;
    }

    protected static abstract class Transformation {
        protected Transformation() {
        }

        public abstract void apply();

        public abstract void unapply();
    }

    protected static class TransformationScale
    extends Transformation {
        protected final Vector2d v;

        public TransformationScale(Vector2d v) {
            this.v = v;
        }

        @Override
        public void apply() {
            GL11.glScaled((double)this.v.x, (double)this.v.y, (double)1.0);
        }

        @Override
        public void unapply() {
            GL11.glScaled((double)(-this.v.x), (double)(-this.v.y), (double)1.0);
        }
    }

    protected static class TransformationTranslate
    extends Transformation {
        protected final Vector2d v;

        public TransformationTranslate(Vector2d v) {
            this.v = v;
        }

        @Override
        public void apply() {
            GL11.glTranslated((double)this.v.x, (double)this.v.y, (double)0.0);
        }

        @Override
        public void unapply() {
            GL11.glTranslated((double)(-this.v.x), (double)(-this.v.y), (double)0.0);
        }
    }
}

