/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.animfx;

import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.animfx.Timeline;

public class Fx<T>
implements Comparable<Fx<T>> {
    public final T step;
    public final double time;
    public final Interpolate method;

    public Fx(T step, double time) {
        this(step, time, null);
    }

    public Fx(T step, double time, Interpolate method) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Time can't be < 0");
        }
        this.step = step;
        this.time = time;
        this.method = method;
    }

    @Override
    public final int compareTo(Fx<T> fx) {
        if (this.time == fx.time) {
            return 0;
        }
        return this.time < fx.time ? -1 : 1;
    }

    public T getState(Fx<?> fx, double d, Interpolate method) {
        if (fx == null) {
            fx = this;
        }
        if (this.step instanceof Integer) {
            return (T)new Integer(method.interpolate((Integer)this.step, (Integer)fx.step, d));
        }
        if (this.step instanceof Float) {
            return (T)new Float(method.interpolate(((Float)this.step).floatValue(), ((Float)fx.step).floatValue(), d));
        }
        if (this.step instanceof Double) {
            return (T)new Double(method.interpolate((Double)this.step, (Double)fx.step, d));
        }
        throw new UnsupportedOperationException();
    }

    public Interpolate getMethod(Timeline<T, ?> timeline) {
        return this.method == null ? timeline.method : this.method;
    }
}

