/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.state.transitions;

import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.transitions.Transition;

public class Transition3DRotation
extends Transition {
    protected final double baseSpeedX;
    protected final double baseSpeedY;
    protected final boolean runUpdate;
    protected double sX;
    protected double sY;
    protected boolean in;

    public Transition3DRotation() {
        this(0.05, 0.0, false);
    }

    public Transition3DRotation(boolean runUpdate) {
        this(0.05, 0.0, runUpdate);
    }

    public Transition3DRotation(double baseSpeedX, double baseSpeedY) {
        this(baseSpeedX, baseSpeedY, false);
    }

    public Transition3DRotation(double baseSpeedX, double baseSpeedY, boolean runUpdate) {
        this.baseSpeedX = baseSpeedX;
        this.baseSpeedY = baseSpeedY;
        this.runUpdate = runUpdate;
    }

    @Override
    public void init(boolean in) {
        this.sY = 1.0;
        this.sX = 1.0;
        if (in) {
            this.in = false;
            while (!this.update()) {
            }
        }
        this.in = in;
    }

    @Override
    public boolean update() {
        this.sX -= this.baseSpeedX * (double)(this.in ? -1 : 1);
        this.sY -= this.baseSpeedY * (double)(this.in ? -1 : 1);
        return this.in ? this.sX >= 1.0 && this.sY >= 1.0 : this.sX <= 0.0 || this.sY <= 0.0;
    }

    @Override
    public void preRender(Graphics g) {
        Vector2i size = State.get().getDisplaySize();
        g.translate((double)size.x * (1.0 - this.sX) / 2.0, (double)size.y * (1.0 - this.sY) / 2.0);
        g.scale(this.sX, this.sY);
    }

    @Override
    public void render(Graphics g) {
        Vector2i size = State.get().getDisplaySize();
        g.preDraw();
        g.scale(1.0 / this.sX, 1.0 / this.sY);
        g.translate((double)(-size.x) * (1.0 - this.sX) / 2.0, (double)(-size.y) * (1.0 - this.sY) / 2.0);
    }

    @Override
    public boolean shouldUpdate() {
        return this.runUpdate;
    }
}

