/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.font;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.font.Font;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Texture;

public class TrueTypeFont
extends Font
implements ITextureSupplier {
    private static IntBuffer scratch = BufferUtils.createIntBuffer((int)16);
    private IntObject[] charArray = new IntObject[256];
    private Map<Character, IntObject> customChars = new HashMap<Character, IntObject>();
    private boolean antiAlias;
    private int fontSize = 0;
    private int fontHeight = 0;
    private int correctL = 9;
    private java.awt.Font font;
    private FontMetrics fontMetrics;
    private Texture texture;

    public TrueTypeFont(String name, int size) {
        this(name, size, false, false);
    }

    public TrueTypeFont(String name, int size, boolean antiAlias) {
        this(name, size, false, false, antiAlias);
    }

    public TrueTypeFont(String name, int size, boolean bold, boolean italic) {
        this(name, size, bold, italic, true);
    }

    public TrueTypeFont(String name, int size, boolean bold, boolean italic, boolean antiAlias) {
        this(name, size, bold, italic, antiAlias, new char[0]);
    }

    public TrueTypeFont(String name, int size, boolean bold, boolean italic, boolean antiAlias, char[] additionalChars) {
        this(new java.awt.Font(name, (bold ? 1 : 0) | (italic ? 2 : 0), size), antiAlias, additionalChars);
    }

    public TrueTypeFont(java.awt.Font font, int size) {
        this(font, size, false, false);
    }

    public TrueTypeFont(java.awt.Font font, int size, boolean antiAlias) {
        this(font, size, false, false, antiAlias);
    }

    public TrueTypeFont(java.awt.Font font, int size, boolean bold, boolean italic) {
        this(font, size, bold, italic, true);
    }

    public TrueTypeFont(java.awt.Font font, int size, boolean bold, boolean italic, boolean antiAlias) {
        this(font, size, bold, italic, antiAlias, new char[0]);
    }

    public TrueTypeFont(java.awt.Font font, int size, boolean bold, boolean italic, boolean antiAlias, char[] additionalChars) {
        this(font.deriveFont((bold ? 1 : 0) | (italic ? 2 : 0), size), antiAlias, additionalChars);
    }

    private TrueTypeFont(java.awt.Font font, boolean antiAlias, char[] additionalChars) {
        this.font = font;
        this.fontSize = font.getSize() + 3;
        this.antiAlias = antiAlias;
        this.createSet(additionalChars);
        --this.fontHeight;
        if (this.fontHeight <= 0) {
            this.fontHeight = 1;
        }
    }

    private BufferedImage getFontImage(char ch) {
        int charheight;
        BufferedImage tempfontImage = new BufferedImage(1, 1, 2);
        Graphics2D g = (Graphics2D)tempfontImage.getGraphics();
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        int charwidth = this.fontMetrics.charWidth(ch) + 8;
        if (charwidth <= 0) {
            charwidth = 7;
        }
        if ((charheight = this.fontMetrics.getHeight() + 3) <= 0) {
            charheight = this.fontSize;
        }
        BufferedImage fontImage = new BufferedImage(charwidth, charheight, 2);
        Graphics2D gt = (Graphics2D)fontImage.getGraphics();
        if (this.antiAlias) {
            gt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        gt.setFont(this.font);
        gt.setColor(Color.WHITE);
        int charx = 3;
        int chary = 1;
        gt.drawString(String.valueOf(ch), charx, chary + this.fontMetrics.getAscent());
        return fontImage;
    }

    private void createSet(char[] customCharsArray) {
        int textureWidth = 512;
        int textureHeight = 512;
        if (customCharsArray != null && customCharsArray.length > 0) {
            textureWidth *= 2;
        }
        try {
            BufferedImage imgTemp = new BufferedImage(textureWidth, textureHeight, 2);
            Graphics2D g = (Graphics2D)imgTemp.getGraphics();
            g.setColor(new Color(0, 0, 0, 1));
            g.fillRect(0, 0, textureWidth, textureHeight);
            int rowHeight = 0;
            int positionX = 0;
            int positionY = 0;
            int customCharsLength = customCharsArray != null ? customCharsArray.length : 0;
            int i = 0;
            while (i < 256 + customCharsLength) {
                char ch = i < 256 ? (char)i : customCharsArray[i - 256];
                BufferedImage fontImage = this.getFontImage(ch);
                IntObject newIntObject = new IntObject();
                newIntObject.width = fontImage.getWidth();
                newIntObject.height = fontImage.getHeight();
                if (positionX + newIntObject.width >= textureWidth) {
                    positionX = 0;
                    positionY += rowHeight;
                    rowHeight = 0;
                }
                newIntObject.storedX = positionX;
                newIntObject.storedY = positionY;
                if (newIntObject.height > this.fontHeight) {
                    this.fontHeight = newIntObject.height;
                }
                if (newIntObject.height > rowHeight) {
                    rowHeight = newIntObject.height;
                }
                g.drawImage((Image)fontImage, positionX, positionY, null);
                positionX += newIntObject.width;
                if (i < 256) {
                    this.charArray[i] = newIntObject;
                } else {
                    this.customChars.put(Character.valueOf(ch), newIntObject);
                }
                fontImage = null;
                ++i;
            }
            this.texture = new Texture(TrueTypeFont.loadImage(imgTemp), textureWidth, textureHeight);
        }
        catch (Exception e) {
            System.err.println("Failed to create font.");
            e.printStackTrace();
        }
    }

    private void drawQuad(double drawX, double drawY, double drawX2, double drawY2, double srcX, double srcY, double srcX2, double srcY2) {
        double DrawWidth = drawX2 - drawX;
        double DrawHeight = drawY2 - drawY;
        double TextureSrcX = srcX / (double)this.texture.getWidth();
        double TextureSrcY = srcY / (double)this.texture.getHeight();
        double SrcWidth = srcX2 - srcX;
        double SrcHeight = srcY2 - srcY;
        double RenderWidth = SrcWidth / (double)this.texture.getWidth();
        double RenderHeight = SrcHeight / (double)this.texture.getHeight();
        GL11.glTexCoord2d((double)TextureSrcX, (double)(TextureSrcY + RenderHeight));
        GL11.glVertex2d((double)drawX, (double)drawY);
        GL11.glTexCoord2d((double)TextureSrcX, (double)TextureSrcY);
        GL11.glVertex2d((double)drawX, (double)(drawY + DrawHeight));
        GL11.glTexCoord2d((double)(TextureSrcX + RenderWidth), (double)TextureSrcY);
        GL11.glVertex2d((double)(drawX + DrawWidth), (double)(drawY + DrawHeight));
        GL11.glTexCoord2d((double)(TextureSrcX + RenderWidth), (double)(TextureSrcY + RenderHeight));
        GL11.glVertex2d((double)(drawX + DrawWidth), (double)drawY);
    }

    @Override
    public int getWidth(String whatchars) {
        IntObject intObject = null;
        int startIndex = 0;
        int endIndex = whatchars.length() - 1;
        int totalwidth = 0;
        int i = startIndex;
        while (i >= startIndex && i <= endIndex) {
            char charCurrent = whatchars.charAt(i);
            IntObject intObject2 = intObject = charCurrent < '\u0100' ? this.charArray[charCurrent] : this.customChars.get(Character.valueOf(charCurrent));
            if (intObject == null) continue;
            totalwidth += intObject.width - this.correctL;
            ++i;
        }
        return totalwidth + 7;
    }

    @Override
    public int getHeight() {
        return this.fontHeight;
    }

    public int getHeight(String HeightString) {
        return this.fontHeight;
    }

    public int getLineHeight() {
        return this.fontHeight;
    }

    @Override
    public void draw(Graphics g, IVector2 v, CharSequence text) {
        this.draw(g, v.Xd(), v.Yd(), text);
    }

    @Override
    public void draw(Graphics g, double x, double y, CharSequence text) {
        this.drawString(x, y, text, 0, text.length() - 1, 1.0f, 1.0f);
    }

    public void drawString(double x, double y, CharSequence whatchars, int startIndex, int endIndex, float scaleX, float scaleY) {
        if (this.disposed()) {
            throw new IllegalStateException("Texture already disposed");
        }
        IntObject intObject = null;
        x = Math.round(x);
        y = Math.round(y);
        int totalwidth = 0;
        int i = startIndex;
        float startY = 0.0f;
        int d = 1;
        int c = this.correctL;
        GL.bind(this.texture);
        GL11.glBegin((int)7);
        while (i >= startIndex && i <= endIndex) {
            char charCurrent = whatchars.charAt(i);
            IntObject intObject2 = intObject = charCurrent < '\u0100' ? this.charArray[charCurrent] : this.customChars.get(Character.valueOf(charCurrent));
            if (intObject == null) continue;
            if (d < 0) {
                totalwidth += (intObject.width - c) * d;
            }
            this.drawQuad((double)((float)(totalwidth + intObject.width) * scaleX) + x, (double)(startY * scaleY) + y, (double)((float)totalwidth * scaleX) + x, (double)((startY + (float)intObject.height) * scaleY) + y, intObject.storedX + intObject.width, intObject.storedY + intObject.height, intObject.storedX, intObject.storedY);
            if (d > 0) {
                totalwidth += (intObject.width - c) * d;
            }
            i += d;
        }
        GL11.glEnd();
    }

    private static int loadImage(BufferedImage bufferedImage) {
        try {
            ByteBuffer byteBuffer;
            DataBuffer db = bufferedImage.getData().getDataBuffer();
            if (db instanceof DataBufferInt) {
                int[] intI = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
                byte[] newI = new byte[intI.length * 4];
                int i = 0;
                while (i < intI.length) {
                    byte[] b = TrueTypeFont.intToByteArray(intI[i]);
                    int newIndex = i * 4;
                    newI[newIndex] = b[1];
                    newI[newIndex + 1] = b[2];
                    newI[newIndex + 2] = b[3];
                    newI[newIndex + 3] = b[0];
                    ++i;
                }
                byteBuffer = ByteBuffer.allocateDirect(bufferedImage.getWidth() * bufferedImage.getHeight() * (bufferedImage.getColorModel().getPixelSize() / 8)).order(ByteOrder.nativeOrder()).put(newI);
            } else {
                byteBuffer = ByteBuffer.allocateDirect(bufferedImage.getWidth() * bufferedImage.getHeight() * (bufferedImage.getColorModel().getPixelSize() / 8)).order(ByteOrder.nativeOrder()).put(((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData());
            }
            byteBuffer.flip();
            int internalFormat = 32856;
            int format = 6408;
            IntBuffer textureId = BufferUtils.createIntBuffer((int)1);
            GL11.glGenTextures((IntBuffer)textureId);
            GL11.glBindTexture((int)3553, (int)textureId.get(0));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
            TrueTypeFont.gluBuild2DMipmaps(3553, internalFormat, bufferedImage.getWidth(), bufferedImage.getHeight(), format, 5121, byteBuffer);
            return textureId.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static int gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, ByteBuffer data) {
        ByteBuffer image;
        int h;
        if (width < 1 || height < 1) {
            return 100901;
        }
        int bpp = TrueTypeFont.bytesPerPixel(format, type);
        if (bpp == 0) {
            return 100900;
        }
        int maxSize = TrueTypeFont.glGetIntegerv(3379);
        int w = TrueTypeFont.nearestPower(width);
        if (w > maxSize) {
            w = maxSize;
        }
        if ((h = TrueTypeFont.nearestPower(height)) > maxSize) {
            h = maxSize;
        }
        PixelStoreState pss = new PixelStoreState();
        GL11.glPixelStorei((int)3330, (int)0);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3331, (int)0);
        GL11.glPixelStorei((int)3332, (int)0);
        int retVal = 0;
        boolean done = false;
        if (w != width || h != height) {
            image = BufferUtils.createByteBuffer((int)((w + 4) * h * bpp));
            int error = TrueTypeFont.gluScaleImage(format, width, height, type, data, w, h, type, image);
            if (error != 0) {
                retVal = error;
                done = true;
            }
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glPixelStorei((int)3315, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
        } else {
            image = data;
        }
        ByteBuffer bufferA = null;
        ByteBuffer bufferB = null;
        int level = 0;
        while (!done) {
            int newH;
            if (image != data) {
                GL11.glPixelStorei((int)3314, (int)0);
                GL11.glPixelStorei((int)3317, (int)1);
                GL11.glPixelStorei((int)3315, (int)0);
                GL11.glPixelStorei((int)3316, (int)0);
            }
            GL11.glTexImage2D((int)target, (int)level, (int)components, (int)w, (int)h, (int)0, (int)format, (int)type, (ByteBuffer)image);
            if (w == 1 && h == 1) break;
            int newW = w < 2 ? 1 : w >> 1;
            int n = newH = h < 2 ? 1 : h >> 1;
            ByteBuffer newImage = bufferA == null ? (bufferA = BufferUtils.createByteBuffer((int)((newW + 4) * newH * bpp))) : (bufferB == null ? (bufferB = BufferUtils.createByteBuffer((int)((newW + 4) * newH * bpp))) : bufferB);
            int error = TrueTypeFont.gluScaleImage(format, w, h, type, image, newW, newH, type, newImage);
            if (error != 0) {
                retVal = error;
                done = true;
            }
            image = newImage;
            if (bufferB != null) {
                bufferB = bufferA;
            }
            w = newW;
            h = newH;
            ++level;
        }
        pss.save();
        return retVal;
    }

    protected static int bytesPerPixel(int format, int type) {
        int m;
        int n;
        switch (format) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: {
                n = 1;
                break;
            }
            case 6410: {
                n = 2;
                break;
            }
            case 6407: 
            case 32992: {
                n = 3;
                break;
            }
            case 6408: 
            case 32993: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        switch (type) {
            case 5120: 
            case 5121: 
            case 6656: {
                m = 1;
                break;
            }
            case 5122: 
            case 5123: {
                m = 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                m = 4;
                break;
            }
            default: {
                m = 0;
            }
        }
        return n * m;
    }

    protected static int nearestPower(int value) {
        int i = 1;
        if (value == 0) {
            return -1;
        }
        while (value != 1) {
            if (value == 3) {
                return i << 2;
            }
            value >>= 1;
            i <<= 1;
        }
        return i;
    }

    protected static int glGetIntegerv(int what) {
        scratch.rewind();
        GL11.glGetInteger((int)what, (IntBuffer)scratch);
        return scratch.get();
    }

    protected static int gluScaleImage(int format, int widthIn, int heightIn, int typein, ByteBuffer dataIn, int widthOut, int heightOut, int typeOut, ByteBuffer dataOut) {
        int j;
        int i;
        int k;
        int sizeout;
        int sizein;
        int components = TrueTypeFont.compPerPix(format);
        if (components == -1) {
            return 100900;
        }
        float[] tempIn = new float[widthIn * heightIn * components];
        float[] tempOut = new float[widthOut * heightOut * components];
        switch (typein) {
            case 5121: {
                sizein = 1;
                break;
            }
            case 5126: {
                sizein = 4;
                break;
            }
            default: {
                return 1280;
            }
        }
        switch (typeOut) {
            case 5121: {
                sizeout = 1;
                break;
            }
            case 5126: {
                sizeout = 4;
                break;
            }
            default: {
                return 1280;
            }
        }
        PixelStoreState pss = new PixelStoreState();
        int rowlen = pss.unpackRowLength > 0 ? pss.unpackRowLength : widthIn;
        int rowstride = sizein >= pss.unpackAlignment ? components * rowlen : pss.unpackAlignment / sizein * TrueTypeFont.ceil(components * rowlen * sizein, pss.unpackAlignment);
        switch (typein) {
            case 5121: {
                k = 0;
                dataIn.rewind();
                i = 0;
                while (i < heightIn) {
                    int ubptr = i * rowstride + pss.unpackSkipRows * rowstride + pss.unpackSkipPixels * components;
                    j = 0;
                    while (j < widthIn * components) {
                        tempIn[k++] = dataIn.get(ubptr++) & 0xFF;
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        float sx = widthIn / widthOut;
        float sy = heightIn / heightOut;
        float[] c = new float[components];
        int iy = 0;
        while (iy < heightOut) {
            int ix = 0;
            while (ix < widthOut) {
                int x0 = (int)((float)ix * sx);
                int x1 = (int)((float)(ix + 1) * sx);
                int y0 = (int)((float)iy * sy);
                int y1 = (int)((float)(iy + 1) * sy);
                int readPix = 0;
                int ic = 0;
                while (ic < components) {
                    c[ic] = 0.0f;
                    ++ic;
                }
                int ix0 = x0;
                while (ix0 < x1) {
                    int iy0 = y0;
                    while (iy0 < y1) {
                        int src = (iy0 * widthIn + ix0) * components;
                        int ic2 = 0;
                        while (ic2 < components) {
                            int n = ic2;
                            c[n] = c[n] + tempIn[src + ic2];
                            ++ic2;
                        }
                        ++readPix;
                        ++iy0;
                    }
                    ++ix0;
                }
                int dst = (iy * widthOut + ix) * components;
                if (readPix == 0) {
                    int src = (y0 * widthIn + x0) * components;
                    int ic3 = 0;
                    while (ic3 < components) {
                        tempOut[dst++] = tempIn[src + ic3];
                        ++ic3;
                    }
                } else {
                    k = 0;
                    while (k < components) {
                        tempOut[dst++] = c[k] / (float)readPix;
                        ++k;
                    }
                }
                ++ix;
            }
            ++iy;
        }
        rowlen = pss.packRowLength > 0 ? pss.packRowLength : widthOut;
        rowstride = sizeout >= pss.packAlignment ? components * rowlen : pss.packAlignment / sizeout * TrueTypeFont.ceil(components * rowlen * sizeout, pss.packAlignment);
        k = 0;
        j = 0;
        i = 0;
        switch (typeOut) {
            case 5121: {
                k = 0;
                i = 0;
                while (i < heightOut) {
                    int ubptr = i * rowstride + pss.packSkipRows * rowstride + pss.packSkipPixels * components;
                    j = 0;
                    while (j < widthOut * components) {
                        dataOut.put(ubptr++, (byte)tempOut[k++]);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    protected static int compPerPix(int format) {
        switch (format) {
            case 6400: 
            case 6401: 
            case 6402: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: {
                return 1;
            }
            case 6410: {
                return 2;
            }
            case 6407: 
            case 32992: {
                return 3;
            }
            case 6408: 
            case 32993: {
                return 4;
            }
        }
        return -1;
    }

    protected static int ceil(int a, int b) {
        return a % b == 0 ? a / b : a / b + 1;
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public Vector2i getTextureSize() {
        return this.getTexture().getSize();
    }

    @Override
    public int getTextureWidth() {
        return this.getTexture().getWidth();
    }

    @Override
    public int getTextureHeight() {
        return this.getTexture().getHeight();
    }

    @Override
    public Rectangle getTextureRect() {
        return new Rectangle(0.0, 0.0, this.getTextureWidth(), this.getTextureHeight());
    }

    @Override
    public void drawTexture(Graphics g) {
        this.drawTexture(g, 0.0, 0.0);
    }

    @Override
    public void drawTexture(Graphics g, IVector2 v) {
        this.drawTexture(g, v.Xd(), v.Yd());
    }

    @Override
    public void drawTexture(Graphics g, double x, double y) {
        if (this.disposed()) {
            throw new IllegalStateException("Texture already disposed");
        }
        GL.bind(this.getTexture());
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)x, (double)y, (double)0.0);
        }
        GL11.glBegin((int)7);
        Rectangle texRect = this.getTextureRect();
        this.internalDrawImage(0.0, 0.0, texRect.size.x, texRect.size.y, texRect.pos.x / (double)this.getTextureWidth(), texRect.pos.y / (double)this.getHeight(), texRect.size.x / (double)this.getTextureWidth(), texRect.size.y / (double)this.getHeight());
        GL11.glEnd();
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        }
        GL.unbindTexture();
    }

    private void internalDrawImage(double x, double y, double w, double h, double tx, double ty, double tw, double th) {
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2d((double)tx, (double)(ty + th));
        GL11.glVertex2d((double)x, (double)(y + h));
        GL11.glTexCoord2d((double)(tx + tw), (double)(ty + th));
        GL11.glVertex2d((double)(x + w), (double)(y + h));
        GL11.glTexCoord2d((double)(tx + tw), (double)ty);
        GL11.glVertex2d((double)(x + w), (double)y);
    }

    @Override
    public boolean disposed() {
        return this.getTexture().disposed();
    }

    @Override
    public void dispose() {
        this.getTexture().dispose();
    }

    protected void finalize() {
        this.dispose();
    }

    private class IntObject {
        public int width;
        public int height;
        public int storedX;
        public int storedY;

        private IntObject() {
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Loadable {
        public String name();

        public int size();

        public boolean bold() default false;

        public boolean italic() default false;

        public boolean antiAlias() default true;

        public char[] additionalChars() default {};
    }

    private static class PixelStoreState {
        public int unpackRowLength;
        public int unpackAlignment;
        public int unpackSkipRows;
        public int unpackSkipPixels;
        public int packRowLength;
        public int packAlignment;
        public int packSkipRows;
        public int packSkipPixels;

        PixelStoreState() {
            this.load();
        }

        public void load() {
            this.unpackRowLength = TrueTypeFont.glGetIntegerv(3314);
            this.unpackAlignment = TrueTypeFont.glGetIntegerv(3317);
            this.unpackSkipRows = TrueTypeFont.glGetIntegerv(3315);
            this.unpackSkipPixels = TrueTypeFont.glGetIntegerv(3316);
            this.packRowLength = TrueTypeFont.glGetIntegerv(3330);
            this.packAlignment = TrueTypeFont.glGetIntegerv(3333);
            this.packSkipRows = TrueTypeFont.glGetIntegerv(3331);
            this.packSkipPixels = TrueTypeFont.glGetIntegerv(3332);
        }

        public void save() {
            GL11.glPixelStorei((int)3314, (int)this.unpackRowLength);
            GL11.glPixelStorei((int)3317, (int)this.unpackAlignment);
            GL11.glPixelStorei((int)3315, (int)this.unpackSkipRows);
            GL11.glPixelStorei((int)3316, (int)this.unpackSkipPixels);
            GL11.glPixelStorei((int)3330, (int)this.packRowLength);
            GL11.glPixelStorei((int)3333, (int)this.packAlignment);
            GL11.glPixelStorei((int)3331, (int)this.packSkipRows);
            GL11.glPixelStorei((int)3332, (int)this.packSkipPixels);
        }
    }
}

