/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.ARBShaderObjects;
import pl.shockah.FileLine;
import pl.shockah.glib.LoadableProcessor;
import pl.shockah.glib.geom.vector.Vector2f;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;

public class Shader {
    private final int sdrId;
    private final Map<String, Integer> cacheUniforms = new HashMap<String, Integer>();
    private boolean mixTexturing = false;

    public static Shader createFromFile(File path) throws IOException {
        return Shader.createFromFile(path, false, true);
    }

    public static Shader createFromFile(File path, boolean mixTexturing, boolean embedConsts) throws IOException {
        String vertex = FileLine.readString(new File(path.getParentFile(), String.valueOf(path.getName()) + ".vert"));
        String fragment = FileLine.readString(new File(path.getParentFile(), String.valueOf(path.getName()) + ".frag"));
        return Shader.create(vertex, fragment, mixTexturing, embedConsts);
    }

    public static Shader createFromPath(String internalPath) throws IOException {
        return Shader.createFromPath(internalPath, false, true);
    }

    public static Shader createFromPath(String internalPath, boolean mixTexturing, boolean embedConsts) throws IOException {
        String vertex = FileLine.readString(new BufferedInputStream(Shader.class.getClassLoader().getResourceAsStream(String.valueOf(internalPath) + ".vert")));
        String fragment = FileLine.readString(new BufferedInputStream(Shader.class.getClassLoader().getResourceAsStream(String.valueOf(internalPath) + ".frag")));
        return Shader.create(vertex, fragment, mixTexturing, embedConsts);
    }

    public static Shader create(String vertex, String fragment) throws IOException {
        return Shader.create(vertex, fragment, false, true);
    }

    public static Shader create(String vertex, String fragment, boolean mixTexturing, boolean embedConsts) throws IOException {
        if (embedConsts) {
            StringBuilder sb = new StringBuilder();
            sb.append("uniform sampler2D tex;\n");
            if (mixTexturing) {
                sb.append("uniform float mixTexturing;\n");
            }
            sb.append("\n");
            fragment = String.valueOf(sb.toString()) + fragment;
        }
        int shaderVertex = Shader.createShader(35633, vertex);
        int shaderFragment = Shader.createShader(35632, fragment);
        if (shaderVertex == 0 || shaderFragment == 0) {
            throw new IOException("Couldn't create shader.");
        }
        int sdrId = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB((int)sdrId, (int)shaderVertex);
        ARBShaderObjects.glAttachObjectARB((int)sdrId, (int)shaderFragment);
        ARBShaderObjects.glLinkProgramARB((int)sdrId);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)sdrId, (int)35714) == 0) {
            throw new IOException("Couldn't create shader.");
        }
        ARBShaderObjects.glValidateProgramARB((int)sdrId);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)sdrId, (int)35715) == 0) {
            throw new IOException("Couldn't create shader.");
        }
        return new Shader(sdrId);
    }

    private static int createShader(int type, String code) throws IOException {
        if (code == null) {
            return 0;
        }
        int id = 0;
        try {
            id = ARBShaderObjects.glCreateShaderObjectARB((int)type);
            if (id == 0) {
                throw new IOException("Couldn't create shader.");
            }
            ARBShaderObjects.glShaderSourceARB((int)id, (CharSequence)code);
            ARBShaderObjects.glCompileShaderARB((int)id);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)id, (int)35713) == 0) {
                throw new IOException("Couldn't create shader.");
            }
            return id;
        }
        catch (Exception e) {
            if (id != 0) {
                ARBShaderObjects.glDeleteObjectARB((int)id);
            }
            throw new IOException("Couldn't create shader.", e);
        }
    }

    public Shader(int sdrId) {
        this.sdrId = sdrId;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Shader)) {
            return false;
        }
        Shader sdr = (Shader)other;
        return sdr.sdrId == this.sdrId;
    }

    public int getID() {
        return this.sdrId;
    }

    private int getUniformLocation(String name) {
        Integer loc;
        Shader old = GL.boundShader();
        if (!this.equals(old)) {
            GL.bind(this);
        }
        if ((loc = this.cacheUniforms.get(name)) == null) {
            loc = ARBShaderObjects.glGetUniformLocationARB((int)this.sdrId, (CharSequence)name);
            this.cacheUniforms.put(name, loc);
        }
        if (!this.equals(old)) {
            GL.bind(old);
        }
        return loc;
    }

    public void setUniform(String name, float f) {
        Shader old = GL.boundShader();
        if (!this.equals(old)) {
            GL.bind(this);
        }
        ARBShaderObjects.glUniform1fARB((int)this.getUniformLocation(name), (float)f);
        if (!this.equals(old)) {
            GL.bind(old);
        }
    }

    public void setUniform(String name, int i) {
        Shader old = GL.boundShader();
        if (!this.equals(old)) {
            GL.bind(this);
        }
        ARBShaderObjects.glUniform1iARB((int)this.getUniformLocation(name), (int)i);
        if (!this.equals(old)) {
            GL.bind(old);
        }
    }

    public void setUniform(String name, Vector2f v) {
        this.setUniform(name, v.x, v.y);
    }

    public void setUniform(String name, float f1, float f2) {
        Shader old = GL.boundShader();
        if (!this.equals(old)) {
            GL.bind(this);
        }
        ARBShaderObjects.glUniform2fARB((int)this.getUniformLocation(name), (float)f1, (float)f2);
        if (!this.equals(old)) {
            GL.bind(old);
        }
    }

    public void setUniform(String name, Vector2i v) {
        this.setUniform(name, v.x, v.y);
    }

    public void setUniform(String name, int i1, int i2) {
        Shader old = GL.boundShader();
        if (!this.equals(old)) {
            GL.bind(this);
        }
        ARBShaderObjects.glUniform2iARB((int)this.getUniformLocation(name), (int)i1, (int)i2);
        if (!this.equals(old)) {
            GL.bind(old);
        }
    }

    public void setMixTexturing(boolean b) {
        this.mixTexturing = b;
    }

    public boolean getMixTexturing() {
        return this.mixTexturing;
    }

    public void handleTexturing(boolean texturing) {
        if (!this.mixTexturing) {
            return;
        }
        this.setUniform("mixTexturing", texturing ? 1.0f : 0.0f);
        this.setUniform("tex", 0);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Loadable {
        public String path() default "assets/images/<field.name>";

        public LoadableProcessor.AssetType type() default LoadableProcessor.AssetType.Internal;

        public boolean mixTexturing() default false;

        public boolean embedConsts() default true;
    }
}

