/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl;

import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.GraphicsGLList;

public class GLList {
    private final int listId;
    private boolean disposed = false;
    protected boolean compiling = false;
    protected boolean finalized = false;
    public final Graphics g;

    public static GLList create() {
        int listId = GL11.glGenLists((int)1);
        return new GLList(listId);
    }

    public GLList(int listId) {
        this.listId = listId;
        this.g = new GraphicsGLList(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GLList)) {
            return false;
        }
        GLList gll = (GLList)other;
        return gll.listId == this.listId;
    }

    public int getID() {
        if (this.disposed) {
            throw new IllegalStateException("GLList already disposed");
        }
        return this.listId;
    }

    public Graphics graphics() {
        if (this.disposed) {
            throw new IllegalStateException("GLList already disposed");
        }
        if (this.finalized) {
            throw new IllegalStateException("GLList already finalized");
        }
        return this.g;
    }

    public void draw(Graphics g) {
        g.draw(this);
    }

    public void draw(Graphics g, IVector2 v) {
        g.draw(this, v);
    }

    public void draw(Graphics g, double x, double y) {
        g.draw(this, x, y);
    }

    public void dispose() {
        if (this.compiling) {
            this.g.onUnbind();
        }
        GL11.glDeleteLists((int)this.getID(), (int)1);
        this.disposed = true;
    }
}

