/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom.vector;

import pl.shockah.Math2;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2f;
import pl.shockah.glib.geom.vector.Vector2i;

public class Vector2d
implements IInterpolatable<Vector2d>,
IVector2 {
    public double x;
    public double y;

    public static Vector2d make(double dist, double angle) {
        return new Vector2d(Math2.ldirX(dist, angle), Math2.ldirY(dist, angle));
    }

    public Vector2d() {
        this(0.0, 0.0);
    }

    public Vector2d(Vector2d v) {
        this(v.x, v.y);
    }

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector2d)) {
            return false;
        }
        Vector2d v = (Vector2d)o;
        return this.x == v.x && this.y == v.y;
    }

    public String toString() {
        return "[Vector2d: " + this.x + ", " + this.y + "]";
    }

    @Override
    public double Xd() {
        return this.x;
    }

    @Override
    public float Xf() {
        return (float)this.x;
    }

    @Override
    public int Xi() {
        return (int)this.x;
    }

    @Override
    public double Yd() {
        return this.y;
    }

    @Override
    public float Yf() {
        return (float)this.y;
    }

    @Override
    public int Yi() {
        return (int)this.y;
    }

    @Override
    public Vector2d copyMe() {
        return new Vector2d(this);
    }

    @Override
    public Vector2i toInt() {
        return new Vector2i((int)this.x, (int)this.y);
    }

    @Override
    public Vector2f toFloat() {
        return new Vector2f((float)this.x, (float)this.y);
    }

    @Override
    public Vector2d toDouble() {
        return this.copyMe();
    }

    public Vector2d set(IVector2 v) {
        return this.set(v.Xd(), v.Yd());
    }

    public Vector2d set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2d setX(IVector2 v) {
        return this.setX(v.Xd());
    }

    public Vector2d setX(double x) {
        this.x = x;
        return this;
    }

    public Vector2d setY(IVector2 v) {
        return this.setY(v.Yd());
    }

    public Vector2d setY(double y) {
        this.y = y;
        return this;
    }

    public Vector2d justX() {
        this.y = 0.0;
        return this;
    }

    public Vector2d JustX() {
        return new Vector2d(this.x, 0.0);
    }

    public Vector2d justY() {
        this.x = 0.0;
        return this;
    }

    public Vector2d JustY() {
        return new Vector2d(0.0, this.y);
    }

    public Vector2d negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2d Negate() {
        return new Vector2d(-this.x, -this.y);
    }

    public Vector2d abs() {
        if (this.x < 0.0) {
            this.x = -this.x;
        }
        if (this.y < 0.0) {
            this.y = -this.y;
        }
        return this;
    }

    public Vector2d Abs() {
        return new Vector2d(this.x >= 0.0 ? this.x : -this.x, this.y >= 0.0 ? this.y : -this.y);
    }

    public Vector2d add(IVector2 v) {
        return this.add(v.Xd(), v.Yd());
    }

    public Vector2d Add(IVector2 v) {
        return this.Add(v.Xd(), v.Yd());
    }

    public Vector2d add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2d Add(double x, double y) {
        return new Vector2d(this.x + x, this.y + y);
    }

    public Vector2d sub(double x, double y) {
        return this.add(-x, -y);
    }

    public Vector2d Sub(double x, double y) {
        return this.Add(-x, -y);
    }

    public Vector2d sub(IVector2 v) {
        return this.sub(v.Xd(), v.Yd());
    }

    public Vector2d Sub(IVector2 v) {
        return this.Sub(v.Xd(), v.Yd());
    }

    public Vector2d scale(double scale) {
        return this.scale(scale, scale);
    }

    public Vector2d Scale(double scale) {
        return this.Scale(scale, scale);
    }

    public Vector2d scale(double scaleH, double scaleV) {
        this.x *= scaleH;
        this.y *= scaleV;
        return this;
    }

    public Vector2d Scale(double scaleH, double scaleV) {
        return new Vector2d(this.x * scaleH, this.y * scaleV);
    }

    public Vector2d scale(IVector2 v) {
        return this.scale(v.Xd(), v.Yd());
    }

    public Vector2d Scale(IVector2 v) {
        return this.Scale(v.Xd(), v.Yd());
    }

    public Vector2d div(double scale) {
        return this.div(scale, scale);
    }

    public Vector2d Div(double scale) {
        return this.Div(scale, scale);
    }

    public Vector2d div(double scaleH, double scaleV) {
        return this.scale(1.0 / scaleH, 1.0 / scaleV);
    }

    public Vector2d Div(double scaleH, double scaleV) {
        return this.Scale(1.0 / scaleH, 1.0 / scaleV);
    }

    public Vector2d div(IVector2 v) {
        return this.div(v.Xd(), v.Yd());
    }

    public Vector2d Div(IVector2 v) {
        return this.Div(v.Xd(), v.Yd());
    }

    public Vector2d Vector(IVector2 v) {
        return new Vector2d(v.Xd() - this.x, v.Yd() - this.y);
    }

    public double lengthSquared() {
        return Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0);
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distanceSquared(IVector2 v) {
        return Math.pow(v.Xd() - this.x, 2.0) + Math.pow(v.Yd() - this.y, 2.0);
    }

    public double distance(IVector2 v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    @Override
    public double direction() {
        return new Vector2d().direction(this);
    }

    @Override
    public double direction(IVector2 v) {
        return Math.toDegrees(Math.atan2(this.y - v.Yd(), v.Xd() - this.x));
    }

    @Override
    public double deltaAngle(IVector2 v) {
        return this.deltaAngle(v.direction());
    }

    @Override
    public double deltaAngle(double angle) {
        double r;
        double a = this.direction();
        while (angle <= -180.0) {
            angle += 360.0;
        }
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (a <= -180.0) {
            a += 360.0;
        }
        while (a > 180.0) {
            a -= 360.0;
        }
        return r + (double)((r = angle - a) > 180.0 ? -360 : (r < -180.0 ? 360 : 0));
    }

    @Override
    public Vector2d interpolate(Vector2d v, double d, Interpolate method) {
        return new Vector2d(method.interpolate(this.x, v.x, d), method.interpolate(this.y, v.y, d));
    }
}

