/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import pl.shockah.Math2;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.Circle;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.font.ETextAlign;
import pl.shockah.glib.gl.font.TextHelper;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.entities.EntityPlayer;
import pl.shockah.ts.entities.EntityWall;

public class EntityWallHint
extends EntityWall {
    public static String globalMessage = null;
    public static float alpha = 0.0f;
    protected final String message;
    protected float ratio = 0.0f;

    public EntityWallHint(String message) {
        this.message = message;
    }

    @Override
    protected void onUpdate() {
        boolean col = this.collidesAt(Entities.getType(EntityPlayer.class).get(0), this.pos.x, this.pos.y - 1.0);
        this.ratio = Math2.limit(this.ratio + (col ? 0.1f : -0.1f), 0.0f, 1.0f);
        if (this.message.equals(globalMessage)) {
            if ((alpha = Math2.limit(alpha + (col ? 0.1f : -0.1f), 0.0f, 1.0f)) <= 0.0f) {
                globalMessage = null;
            }
        } else if (globalMessage == null && col) {
            globalMessage = this.message;
        }
    }

    @Override
    protected void onRegister() {
        super.onRegister();
        new Renderable(this, -0.4){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.Black.interpolate(Color.White, (double)EntityWallHint.this.ratio, Interpolate.Linear).alpha(0.5f));
                g.draw(new Circle(EntityWallHint.this.pos.x + 12.0, EntityWallHint.this.pos.y + 12.0, 8.0).asPolygon(16));
                GL.setThickness(2.0f);
                g.setColor(Color.White.interpolate(Color.Black, (double)EntityWallHint.this.ratio, Interpolate.Linear).alpha(0.5f));
                g.draw(new Circle(EntityWallHint.this.pos.x + 12.0, EntityWallHint.this.pos.y + 12.0, 9.0).asPolygon(16), false);
                GL.setThickness(1.0f);
            }
        }.create();
        new Renderable(this, -0.5){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.Black);
                int yy = -1;
                while (yy <= 1) {
                    int xx = -1;
                    while (xx <= 1) {
                        TextHelper.draw(g, Assets.font16, EntityWallHint.this.pos.x + 12.0 + (double)xx, EntityWallHint.this.pos.y + 3.0 + (double)yy, (CharSequence)"?", ETextAlign.TopCenter);
                        xx += 2;
                    }
                    yy += 2;
                }
                g.setColor(Color.White);
                TextHelper.draw(g, Assets.font16, EntityWallHint.this.pos.x + 12.0, EntityWallHint.this.pos.y + 3.0, (CharSequence)"?", ETextAlign.TopCenter);
            }
        }.create();
    }
}

