/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.json;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pl.shockah.json.JSONList;

public class JSONObject {
    protected Map<String, Object> map = Collections.synchronizedMap(new LinkedHashMap());

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    public List<String> keys() {
        return new LinkedList<String>(this.map.keySet());
    }

    public List<Map.Entry<String, Object>> entries() {
        return new LinkedList<Map.Entry<String, Object>>(this.map.entrySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isNull(String key) {
        return this.contains(key) && this.map.get(key) == null;
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public String getString(String key) {
        Object o = this.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        throw new IllegalArgumentException("Key '" + key + "' doesn't hold a string.");
    }

    public boolean getBoolean(String key) {
        Object o = this.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException("Key '" + key + "' doesn't hold a boolean.");
    }

    public Number getNumber(String key) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new IllegalArgumentException("Key '" + key + "' doesn't hold a number.");
    }

    public int getInt(String key) {
        return this.getNumber(key).intValue();
    }

    public long getLong(String key) {
        return this.getNumber(key).longValue();
    }

    public float getFloat(String key) {
        return this.getNumber(key).floatValue();
    }

    public double getDouble(String key) {
        return this.getNumber(key).doubleValue();
    }

    public JSONObject getObject(String key) {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new IllegalArgumentException("Key '" + key + "' doesn't hold a JSONObject.");
    }

    public JSONList<?> getList(String key) {
        Object o = this.get(key);
        if (o instanceof JSONList) {
            return (JSONList)o;
        }
        throw new IllegalArgumentException("Key '" + key + "' doesn't hold a JSONList.");
    }

    public void put(String key, Object o) {
        if (!(o == null || o instanceof String || o instanceof Number || o instanceof Boolean || o instanceof JSONObject || o instanceof JSONList)) {
            throw new IllegalArgumentException("Can't store this type of object.");
        }
        this.map.put(key, o);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }
}

