/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.logic.standard;

import java.util.LinkedList;
import java.util.List;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.logic.standard.EntityRenderable;

public class EntityCollidable
extends EntityRenderable {
    protected Shape shape = null;

    public void updateShapePos() {
        if (this.shape == null) {
            return;
        }
        this.shape.translateTo(this.pos);
    }

    public boolean collides(Shape shape) {
        return this.collides(shape, true);
    }

    public boolean collides(Shape shape, boolean update) {
        if (shape == null || this.shape == null) {
            return false;
        }
        if (update) {
            this.updateShapePos();
        }
        return this.shape.collides(shape);
    }

    public boolean collides(EntityCollidable e) {
        return this.collides(e, true);
    }

    private boolean collides(EntityCollidable e, boolean update) {
        if (e == null) {
            return false;
        }
        if (e == this) {
            return false;
        }
        if (this.shape == null || e.shape == null) {
            return false;
        }
        if (update) {
            this.updateShapePos();
        }
        e.updateShapePos();
        return this.shape.collides(e.shape);
    }

    public boolean collidesAt(EntityCollidable e, IVector2 v) {
        return this.collidesAt(e, v.Xd(), v.Yd());
    }

    public boolean collidesAt(EntityCollidable e, double x, double y) {
        if (this.shape == null) {
            return false;
        }
        Vector2d diff = this.shape.translateTo(x, y);
        boolean b = this.collides(e, false);
        this.updateShapePos();
        this.shape.translate(diff);
        return b;
    }

    public boolean collides(List<EntityCollidable> list) {
        return this.collides(list, true);
    }

    public boolean collides(List<EntityCollidable> list, boolean update) {
        if (this.shape == null) {
            return false;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (EntityCollidable e : list) {
            if (!this.collides(e, update)) continue;
            return true;
        }
        return false;
    }

    public boolean collidesAt(List<EntityCollidable> list, IVector2 v) {
        return this.collidesAt(list, v.Xd(), v.Yd());
    }

    public boolean collidesAt(List<EntityCollidable> list, double x, double y) {
        if (this.shape == null) {
            return false;
        }
        this.updateShapePos();
        Vector2d diff = this.shape.translateTo(x, y);
        boolean b = this.collides(list, false);
        this.shape.translate(diff);
        return b;
    }

    public List<EntityCollidable> collidesWith(List<EntityCollidable> list) {
        return this.collidesWith(list, true);
    }

    public List<EntityCollidable> collidesWith(List<EntityCollidable> list, boolean update) {
        LinkedList<EntityCollidable> ret = new LinkedList<EntityCollidable>();
        if (this.shape == null) {
            return ret;
        }
        if (list == null || list.isEmpty()) {
            return ret;
        }
        for (EntityCollidable e : list) {
            if (!this.collides(e, update)) continue;
            ret.add(e);
        }
        return ret;
    }

    public List<EntityCollidable> collidesAtWith(List<EntityCollidable> list, IVector2 v) {
        return this.collidesAtWith(list, v.Xd(), v.Yd());
    }

    public List<EntityCollidable> collidesAtWith(List<EntityCollidable> list, double x, double y) {
        if (this.shape == null) {
            return new LinkedList<EntityCollidable>();
        }
        this.updateShapePos();
        Vector2d diff = this.shape.translateTo(x, y);
        List<EntityCollidable> ret = this.collidesWith(list, false);
        this.shape.translate(diff);
        return ret;
    }
}

