/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Texture;

public abstract class TextureSupplier
implements ITextureSupplier {
    private final Texture tex;
    public Vector2d offset = new Vector2d();
    public Vector2d scale = new Vector2d(1.0, 1.0);

    public TextureSupplier(Texture tex) {
        this.tex = tex;
    }

    @Override
    public Texture getTexture() {
        return this.tex;
    }

    @Override
    public Vector2i getTextureSize() {
        return this.tex.getSize();
    }

    @Override
    public int getTextureWidth() {
        return this.tex.getWidth();
    }

    @Override
    public int getTextureHeight() {
        return this.tex.getHeight();
    }

    public int getTextureWidthFold() {
        return this.tex.getWidthFold();
    }

    public int getTextureHeightFold() {
        return this.tex.getHeightFold();
    }

    @Override
    public Rectangle getTextureRect() {
        return new Rectangle(0.0, 0.0, this.getTextureWidth(), this.getTextureHeight());
    }

    public Vector2i getSize() {
        return this.getTextureSize();
    }

    public double getWidth() {
        return this.getTextureRect().size.x;
    }

    public double getHeight() {
        return this.getTextureRect().size.y;
    }

    public double getWidthScaled() {
        return this.getWidth() * this.scale.x;
    }

    public double getHeightScaled() {
        return this.getHeight() * this.scale.y;
    }

    @Override
    public void drawTexture(Graphics g) {
        this.drawTexture(g, 0.0, 0.0);
    }

    @Override
    public void drawTexture(Graphics g, IVector2 v) {
        this.drawTexture(g, v.Xd(), v.Yd());
    }

    @Override
    public void drawTexture(Graphics g, double x, double y) {
        if (this.disposed()) {
            throw new IllegalStateException("Texture already disposed");
        }
        g.preDraw();
        GL.bind(this.getTexture());
        if (this.offset.x != 0.0 || this.offset.y != 0.0) {
            GL11.glTranslated((double)(-this.offset.x * this.scale.x), (double)(-this.offset.y * this.scale.y), (double)0.0);
        }
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)x, (double)y, (double)0.0);
        }
        this.preDraw(g);
        GL11.glBegin((int)7);
        Rectangle texRect = this.getTextureRect();
        this.internalDrawImage(0.0, 0.0, texRect.size.x * this.scale.x, texRect.size.y * this.scale.y, texRect.pos.x / (double)this.getTextureWidthFold(), texRect.pos.y / (double)this.getTextureHeightFold(), texRect.size.x / (double)this.getTextureWidthFold(), texRect.size.y / (double)this.getTextureHeightFold());
        GL11.glEnd();
        this.postDraw(g);
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        }
        if (this.offset.x != 0.0 || this.offset.y != 0.0) {
            GL11.glTranslated((double)(this.offset.x * this.scale.x), (double)(this.offset.y * this.scale.y), (double)0.0);
        }
    }

    public void drawTextureMulticolor(Graphics g, Color cTopLeft, Color cTopRight, Color cBottomLeft, Color cBottomRight) {
        this.drawTextureMulticolor(g, 0.0, 0.0, cTopLeft, cTopRight, cBottomLeft, cBottomRight);
    }

    public void drawTextureMulticolor(Graphics g, IVector2 v, Color cTopLeft, Color cTopRight, Color cBottomLeft, Color cBottomRight) {
        this.drawTextureMulticolor(g, v.Xd(), v.Yd(), cTopLeft, cTopRight, cBottomLeft, cBottomRight);
    }

    public void drawTextureMulticolor(Graphics g, double x, double y, Color cTopLeft, Color cTopRight, Color cBottomLeft, Color cBottomRight) {
        if (this.disposed()) {
            throw new IllegalStateException("Texture already disposed");
        }
        g.preDraw();
        GL.bind(this.getTexture());
        if (this.offset.x != 0.0 || this.offset.y != 0.0) {
            GL11.glTranslated((double)(-this.offset.x * this.scale.x), (double)(-this.offset.y * this.scale.y), (double)0.0);
        }
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)x, (double)y, (double)0.0);
        }
        this.preDraw(g);
        GL11.glBegin((int)7);
        Rectangle texRect = this.getTextureRect();
        this.internalDrawImageMulticolor(0.0, 0.0, texRect.size.x * this.scale.x, texRect.size.y * this.scale.y, texRect.pos.x / (double)this.getTextureWidthFold(), texRect.pos.y / (double)this.getTextureHeightFold(), texRect.size.x / (double)this.getTextureWidthFold(), texRect.size.y / (double)this.getTextureHeightFold(), cTopLeft, cTopRight, cBottomLeft, cBottomRight);
        GL11.glEnd();
        this.postDraw(g);
        if (x != 0.0 || y != 0.0) {
            GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        }
        if (this.offset.x != 0.0 || this.offset.y != 0.0) {
            GL11.glTranslated((double)(this.offset.x * this.scale.x), (double)(this.offset.y * this.scale.y), (double)0.0);
        }
    }

    private void internalDrawImage(double x, double y, double w, double h, double tx, double ty, double tw, double th) {
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2d((double)tx, (double)(ty + th));
        GL11.glVertex2d((double)x, (double)(y + h));
        GL11.glTexCoord2d((double)(tx + tw), (double)(ty + th));
        GL11.glVertex2d((double)(x + w), (double)(y + h));
        GL11.glTexCoord2d((double)(tx + tw), (double)ty);
        GL11.glVertex2d((double)(x + w), (double)y);
    }

    private void internalDrawImageMulticolor(double x, double y, double w, double h, double tx, double ty, double tw, double th, Color cTopLeft, Color cTopRight, Color cBottomLeft, Color cBottomRight) {
        GL.bind(cTopLeft);
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex2d((double)x, (double)y);
        GL.bind(cBottomLeft);
        GL11.glTexCoord2d((double)tx, (double)(ty + th));
        GL11.glVertex2d((double)x, (double)(y + h));
        GL.bind(cBottomRight);
        GL11.glTexCoord2d((double)(tx + tw), (double)(ty + th));
        GL11.glVertex2d((double)(x + w), (double)(y + h));
        GL.bind(cTopRight);
        GL11.glTexCoord2d((double)(tx + tw), (double)ty);
        GL11.glVertex2d((double)(x + w), (double)y);
    }

    protected void preDraw(Graphics g) {
    }

    protected void postDraw(Graphics g) {
    }

    @Override
    public boolean disposed() {
        return this.tex.disposed();
    }

    @Override
    public void dispose() {
        this.tex.dispose();
    }
}

