/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom.polygon;

import pl.shockah.glib.geom.polygon.ITriangulator;
import pl.shockah.glib.geom.vector.Vector2d;

public class NeatTriangulator
implements ITriangulator {
    static final float EPSILON = 1.0E-6f;
    private double[] pointsX = new double[100];
    private double[] pointsY = new double[100];
    private int numPoints = 0;
    private Edge[] edges = new Edge[100];
    private int[] V;
    private int numEdges = 0;
    private Triangle[] triangles = new Triangle[100];
    private int numTriangles = 0;
    private float offset = 1.0E-6f;

    public void clear() {
        this.numPoints = 0;
        this.numEdges = 0;
        this.numTriangles = 0;
    }

    private int findEdge(int i, int j) {
        int l;
        int k;
        if (i < j) {
            k = i;
            l = j;
        } else {
            k = j;
            l = i;
        }
        int i1 = 0;
        while (i1 < this.numEdges) {
            if (this.edges[i1].v0 == k && this.edges[i1].v1 == l) {
                return i1;
            }
            ++i1;
        }
        return -1;
    }

    private void addEdge(int i, int j, int k) {
        int i1;
        int l;
        Edge edge;
        int j1;
        int k1;
        int l1 = this.findEdge(i, j);
        if (l1 < 0) {
            if (this.numEdges == this.edges.length) {
                Edge[] aedge = new Edge[this.edges.length * 2];
                System.arraycopy(this.edges, 0, aedge, 0, this.numEdges);
                this.edges = aedge;
            }
            k1 = -1;
            j1 = -1;
            l1 = this.numEdges++;
            edge = this.edges[l1] = new Edge();
        } else {
            edge = this.edges[l1];
            j1 = edge.t0;
            k1 = edge.t1;
        }
        if (i < j) {
            l = i;
            i1 = j;
            j1 = k;
        } else {
            l = j;
            i1 = i;
            k1 = k;
        }
        edge.v0 = l;
        edge.v1 = i1;
        edge.t0 = j1;
        edge.t1 = k1;
        edge.suspect = true;
    }

    void markSuspect(int i, int j, boolean flag) throws InternalException {
        int k = this.findEdge(i, j);
        if (k < 0) {
            throw new InternalException("Attempt to mark unknown edge");
        }
        this.edges[k].suspect = flag;
    }

    private static boolean insideTriangle(double f, double f1, double f2, double f3, double f4, double f5, double f6, double f7) {
        double f8 = f4 - f2;
        double f9 = f5 - f3;
        double f10 = f - f4;
        double f11 = f1 - f5;
        double f12 = f2 - f;
        double f13 = f3 - f1;
        double f14 = f6 - f;
        double f15 = f7 - f1;
        double f16 = f6 - f2;
        double f17 = f7 - f3;
        double f18 = f6 - f4;
        double f19 = f7 - f5;
        double f22 = f8 * f17 - f9 * f16;
        double f20 = f12 * f15 - f13 * f14;
        double f21 = f10 * f19 - f11 * f18;
        return f22 >= 0.0 && f21 >= 0.0 && f20 >= 0.0;
    }

    private boolean snip(int i, int j, int k, int l) {
        double f2 = this.pointsX[this.V[j]];
        double f = this.pointsX[this.V[i]];
        double f5 = this.pointsY[this.V[k]];
        double f1 = this.pointsY[this.V[i]];
        double f3 = this.pointsY[this.V[j]];
        double f4 = this.pointsX[this.V[k]];
        if ((double)1.0E-6f > (f2 - f) * (f5 - f1) - (f3 - f1) * (f4 - f)) {
            return false;
        }
        int i1 = 0;
        while (i1 < l) {
            double f7;
            double f6;
            if (i1 != i && i1 != j && i1 != k && NeatTriangulator.insideTriangle(f, f1, f2, f3, f4, f5, f6 = this.pointsX[this.V[i1]], f7 = this.pointsY[this.V[i1]])) {
                return false;
            }
            ++i1;
        }
        return true;
    }

    private double area() {
        double f = 0.0;
        int i = this.numPoints - 1;
        int j = 0;
        while (j < this.numPoints) {
            f += this.pointsX[i] * this.pointsY[j] - this.pointsY[i] * this.pointsX[j];
            i = j++;
        }
        return f * 0.5;
    }

    public void basicTriangulation() throws InternalException {
        int i = this.numPoints;
        if (i < 3) {
            return;
        }
        this.numEdges = 0;
        this.numTriangles = 0;
        this.V = new int[i];
        if (0.0 < this.area()) {
            int k = 0;
            while (k < i) {
                this.V[k] = k;
                ++k;
            }
        } else {
            int l = 0;
            while (l < i) {
                this.V[l] = this.numPoints - 1 - l;
                ++l;
            }
        }
        int k1 = 2 * i;
        int i1 = i - 1;
        while (i > 2) {
            int j1;
            if (k1-- <= 0) {
                throw new InternalException("Bad polygon");
            }
            int j = i1;
            if (i <= j) {
                j = 0;
            }
            if (i <= (i1 = j + 1)) {
                i1 = 0;
            }
            if (i <= (j1 = i1 + 1)) {
                j1 = 0;
            }
            if (!this.snip(j, i1, j1, i)) continue;
            int l1 = this.V[j];
            int i2 = this.V[i1];
            int j2 = this.V[j1];
            if (this.numTriangles == this.triangles.length) {
                Triangle[] atriangle = new Triangle[this.triangles.length * 2];
                System.arraycopy(this.triangles, 0, atriangle, 0, this.numTriangles);
                this.triangles = atriangle;
            }
            this.triangles[this.numTriangles] = new Triangle(l1, i2, j2);
            this.addEdge(l1, i2, this.numTriangles);
            this.addEdge(i2, j2, this.numTriangles);
            this.addEdge(j2, l1, this.numTriangles);
            ++this.numTriangles;
            int k2 = i1;
            int l2 = i1 + 1;
            while (l2 < i) {
                this.V[k2] = this.V[l2];
                ++k2;
                ++l2;
            }
            k1 = 2 * --i;
        }
        this.V = null;
    }

    @Override
    public boolean triangulate() {
        try {
            this.basicTriangulation();
            return true;
        }
        catch (InternalException e) {
            this.numEdges = 0;
            return false;
        }
    }

    @Override
    public void addPolyPoint(Vector2d point) {
        int i = 0;
        while (i < this.numPoints) {
            if (this.pointsX[i] == point.x && this.pointsY[i] == point.y) {
                point = new Vector2d(point.x, point.y + (double)this.offset);
                this.offset += 1.0E-6f;
            }
            ++i;
        }
        if (this.numPoints == this.pointsX.length) {
            double[] af = new double[this.numPoints * 2];
            System.arraycopy(this.pointsX, 0, af, 0, this.numPoints);
            this.pointsX = af;
            af = new double[this.numPoints * 2];
            System.arraycopy(this.pointsY, 0, af, 0, this.numPoints);
            this.pointsY = af;
        }
        this.pointsX[this.numPoints] = point.x;
        this.pointsY[this.numPoints] = point.y;
        ++this.numPoints;
    }

    @Override
    public int getTriangleCount() {
        return this.numTriangles;
    }

    @Override
    public Vector2d getTrianglePoint(int tri, int i) {
        double xp = this.pointsX[this.triangles[tri].v[i]];
        double yp = this.pointsY[this.triangles[tri].v[i]];
        return new Vector2d(xp, yp);
    }

    @Override
    public void startHole() {
    }

    class Edge {
        int v0 = -1;
        int v1 = -1;
        int t0 = -1;
        int t1 = -1;
        boolean suspect;

        Edge() {
        }
    }

    class InternalException
    extends Exception {
        private static final long serialVersionUID = 4126578960568998025L;

        public InternalException(String msg) {
            super(msg);
        }
    }

    class Triangle {
        int[] v = new int[3];

        Triangle(int i, int j, int k) {
            this.v[0] = i;
            this.v[1] = j;
            this.v[2] = k;
        }
    }
}

