/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib;

import java.util.List;
import org.lwjgl.Sys;
import pl.shockah.Util;
import pl.shockah.glib.LoadableProcessor;
import pl.shockah.glib.state.State;

public class AssetLoader {
    protected final List<LoadableProcessor.LoadAction<?>> toLoad;
    protected int loaded = 0;
    protected double currentStatus = 0.0;

    public AssetLoader() {
        this(Util.getCallingClass(AssetLoader.class));
    }

    public AssetLoader(Class<?> cls) {
        this(LoadableProcessor.process(cls));
    }

    public AssetLoader(List<LoadableProcessor.LoadAction<?>> toLoad) {
        this.toLoad = toLoad;
    }

    public int getLoadedCount() {
        return this.loaded;
    }

    public int getToLoadCount() {
        return this.toLoad.size();
    }

    public int getTotalCount() {
        return this.loaded + this.toLoad.size();
    }

    public boolean finished() {
        return this.getLoadedCount() == this.getTotalCount();
    }

    public void update() {
        this.update(1000 / State.get().getFPS());
    }

    public void update(int maxms) {
        long time = this.getTime();
        while (!this.toLoad.isEmpty()) {
            if (this.toLoad.get(0).load(this)) {
                this.toLoad.remove(0);
                ++this.loaded;
                this.currentStatus = 0.0;
            }
            if (this.getTime() - time >= (long)maxms) break;
        }
    }

    public void setCurrentStatus(double d) {
        this.currentStatus = d;
    }

    public double getStatus() {
        double d = 1.0 * (double)this.getLoadedCount() / (double)this.getTotalCount();
        return d += this.currentStatus / (double)this.getTotalCount();
    }

    private long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }
}

