/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities.waterblur;

import java.util.List;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.entities.waterblur.IWaterBlur;
import pl.shockah.ts.gameplay.Game;

public final class WaterBlur {
    public static final int blurLayers = 6;
    public static boolean blur = false;
    public static float blurAlpha = 1.0f;
    private static double sin = 0.0;

    public static void toggle() {
        blur = !blur;
        blurAlpha = blur ? 0.16666667f : 1.0f;
    }

    public static void render(Graphics g) {
        WaterBlur.toggle();
        sin += Game.me.time.getSpeed() / 60.0;
        double[] _blurAngle = new double[6];
        double[] _blurDist = new double[6];
        Vector2d[] _v = new Vector2d[6];
        int i = 0;
        while (i < 6) {
            _blurAngle[i] = 60.0 * (double)i + Math.sin(sin * Math.pow(i, 1.2)) * 60.0;
            _blurDist[i] = 1.5 + Math.sin(sin * Math.pow(i, 0.9));
            _v[i] = Vector2d.make(_blurDist[i], _blurAngle[i]);
            ++i;
        }
        for (Renderable r : Entities.getRenderable()) {
            EntityRenderable er = r.getParent();
            if (er == null || !(er instanceof IWaterBlur) || !WaterBlur.isInWater((EntityCollidable)er)) continue;
            int i2 = 0;
            while (i2 < 6) {
                g.translate(-_v[i2].x, -_v[i2].y);
                r.render(g);
                g.translate(_v[i2].x, _v[i2].y);
                ++i2;
            }
        }
        WaterBlur.toggle();
    }

    public static boolean isInWater(EntityCollidable e) {
        if (Game.me.cacheWaterShapes.isEmpty()) {
            WaterBlur.cacheWaterShapes();
        }
        for (Shape shape : Game.me.cacheWaterShapes) {
            if (!e.collides(shape)) continue;
            return true;
        }
        return false;
    }

    private static void cacheWaterShapes() {
        List<Shape> list = Game.me.cacheWaterShapes;
        list.clear();
        int y = 0;
        while (y < Game.me.tileSize.y) {
            int x = 0;
            while (x < Game.me.tileSize.x) {
                if (Game.me.water[x][y]) {
                    boolean above = y != 0 && Game.me.water[x][y - 1];
                    list.add(new Rectangle(x * 24, (double)(y * 24) + (above ? 0.0 : 6.5), 24.0, 24.0 - (above ? 0.0 : 6.5)));
                }
                ++x;
            }
            ++y;
        }
    }
}

