/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import java.util.List;
import pl.shockah.Math2;
import pl.shockah.Util;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.BlendMode;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.input.KInput;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityBase;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.glib.particle.ParticleSystem;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.transitions.TransitionThroughColor;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;
import pl.shockah.ts.entities.EntityBox;
import pl.shockah.ts.entities.EntityBoxPushable;
import pl.shockah.ts.entities.EntityWall;
import pl.shockah.ts.entities.IGravity;
import pl.shockah.ts.entities.effects.EffectJumpRipple;
import pl.shockah.ts.entities.waterblur.IWaterBlur;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.ETime;
import pl.shockah.ts.gameplay.Game;
import pl.shockah.ts.gameplay.TestLevel;
import pl.shockah.ts.particles.PtLand;
import pl.shockah.ts.particles.PtSkidJump;
import pl.shockah.ts.states.StateGame;

public class EntityPlayer
extends EntityCollidable
implements IGravity,
IWaterBlur {
    public Vector2d toMove = new Vector2d();
    public Vector2d vel = new Vector2d();
    public Jumps jumps = new Jumps();
    protected int frame = 0;
    protected boolean doingSkid = false;
    protected boolean doSlide = false;
    protected boolean didPush = false;
    protected ParticleSystem ps = new ParticleSystem();
    protected ParticleSystem ps2 = new ParticleSystem(BlendMode.Normal);

    public EntityPlayer() {
        this.baseDepth = 5.0;
    }

    @Override
    protected void onCreate() {
        this.shape = new Rectangle(this.pos.x, this.pos.y, 24.0, 24.0);
    }

    protected double getXAcceleration() {
        return 0.5;
    }

    protected double getXDeceleration() {
        return 0.25;
    }

    protected double getYAcceleration(boolean againstWall, boolean water) {
        return (againstWall ? 0.125 : 0.5) * (double)(water ? 0.6666667f : 1.0f);
    }

    protected double getXVelocityLimit() {
        return 4.0;
    }

    protected double getYVelocityLimit(boolean againstWall) {
        return againstWall ? 3.0 : 12.0;
    }

    protected double getWallJumpXVelocity() {
        return 8.0;
    }

    protected double getJumpYVelocity(boolean skid, boolean wall) {
        if (wall) {
            return 6.0;
        }
        if (skid) {
            return 11.0;
        }
        return 8.5;
    }

    @Override
    protected void onUpdate() {
        boolean v;
        boolean h;
        int sign2;
        if (KInput.isPressed(2)) {
            State.change(new StateGame(TestLevel.level1), new TransitionThroughColor(Color.Black, 0.025f), new TransitionThroughColor(Color.Black, 0.025f, true));
        }
        if (KInput.isPressed(3)) {
            State.change(new StateGame(TestLevel.level2), new TransitionThroughColor(Color.Black, 0.025f), new TransitionThroughColor(Color.Black, 0.025f, true));
        }
        if (KInput.isPressed(4)) {
            State.change(new StateGame(TestLevel.level3), new TransitionThroughColor(Color.Black, 0.025f), new TransitionThroughColor(Color.Black, 0.025f, true));
        }
        if (KInput.isPressed(5)) {
            State.change(new StateGame(TestLevel.level4), new TransitionThroughColor(Color.Black, 0.025f), new TransitionThroughColor(Color.Black, 0.025f, true));
        }
        if (KInput.isPressed(44)) {
            Game.me.time = ETime.Stop;
        }
        if (KInput.isPressed(45)) {
            Game.me.time = ETime.Slow;
        }
        if (KInput.isPressed(46)) {
            Game.me.time = ETime.Normal;
        }
        List<EntityCollidable> platforms = Util.getAllOf(this.getPlatforms(), EntityCollidable.class);
        this.didPush = false;
        boolean collidesU = this.collidesAt(platforms, this.pos.x, this.pos.y - 1.0);
        boolean collidesD = this.collidesAt(platforms, this.pos.x, this.pos.y + 1.0);
        boolean inWater = WaterBlur.isInWater(this);
        boolean l = KInput.isDown(203);
        boolean r = KInput.isDown(205);
        int dir = (r ? 1 : 0) - (l ? 1 : 0);
        int sign = (int)Math.signum(this.vel.x);
        if (dir == 0 || dir == sign && Math.abs(this.vel.x) >= this.getXVelocityLimit()) {
            this.vel.x -= this.getXDeceleration() * (double)sign;
            if (dir != 0) {
                this.doSlide = true;
            }
            if (sign != (sign2 = (int)Math.signum(this.vel.x))) {
                this.vel.x = 0.0;
            }
        } else {
            if (Math.abs(this.vel.x) >= this.getXVelocityLimit()) {
                this.frame += sign * 4;
            }
            if (sign != dir && sign != 0) {
                this.vel.x += this.getXDeceleration() * (double)dir;
            }
            this.vel.x += this.getXAcceleration() * (double)dir;
            sign2 = (int)Math.signum(this.vel.x);
            if (sign2 == dir && Math.abs(this.vel.x) > this.getXVelocityLimit()) {
                this.vel.x = this.getXVelocityLimit() * (double)sign2;
            }
        }
        if (dir != 0 && sign != 0 && dir != sign && Math.abs(this.vel.x) >= 0.0 && this.doSlide && collidesD) {
            int i = 0;
            while ((double)i < this.getXVelocityLimit()) {
                PtLand.make(this.ps2, this.pos.Add(12.0, 24.0), this.vel.x > 0.0);
                ++i;
            }
            this.doSlide = false;
        }
        if (KInput.isPressed(200) && !collidesU) {
            if (dir != 0 && !collidesD && !inWater && this.collidesAt(platforms, this.pos.x + (double)dir, this.pos.y)) {
                this.vel.y = -this.getJumpYVelocity(false, true);
                this.vel.x = -this.getWallJumpXVelocity() * (double)dir;
                new EffectJumpRipple(EffectJumpRipple.EOrientation.Vertical).create(this.pos.Add(12 + dir * 12, 12.0));
            } else if (this.jumps.canMake() || inWater) {
                double jumpPower = this.getJumpYVelocity(false, false);
                boolean skid = false;
                this.doingSkid = false;
                if (this.jumps.firstJump()) {
                    if (dir == -sign && this.vel.x != 0.0 && !inWater) {
                        jumpPower = this.getJumpYVelocity(true, false);
                        skid = true;
                        this.doingSkid = true;
                    }
                } else {
                    new EffectJumpRipple(EffectJumpRipple.EOrientation.Horizontal).create(this.pos.Add(12.0, 24.0));
                }
                this.jumps.make();
                this.vel.y = -jumpPower;
                if (dir != 0 && dir != sign) {
                    this.vel.x = skid ? 0.0 : -this.vel.x;
                }
            }
        } else if (!collidesD) {
            this.jumps.fall();
            boolean againstWall = dir != 0 && this.collidesAt(platforms, this.pos.x + (double)dir, this.pos.y) && this.vel.y >= 0.0 && !inWater;
            double fallSpeed = this.getYAcceleration(againstWall, inWater);
            double limit = this.getYVelocityLimit(againstWall);
            if (this.vel.y < limit) {
                this.vel.y += fallSpeed;
            }
            if (this.vel.y > limit) {
                this.vel.y -= fallSpeed;
                if (this.vel.y < limit) {
                    this.vel.y = limit;
                }
            }
            if (againstWall && this.vel.y >= limit && Main.rand.nextInt(3) == 0) {
                PtLand.make(this.ps2, this.pos.Add(12 + dir * 12, 0.0), 90.0 + (double)dir * 15.0);
            }
        } else {
            this.jumps.reset();
        }
        if (this.vel.y >= 0.0) {
            this.doingSkid = false;
        }
        this.toMove.add(new Vector2d(inWater ? this.vel.x / 4.0 : this.vel.x, inWater ? this.vel.y / 4.0 : this.vel.y));
        do {
            int sign22;
            h = false;
            v = false;
            if (this.toMove.x >= 0.5 || this.toMove.x < -0.5) {
                h = true;
                sign22 = (int)Math.signum(this.toMove.x);
                List<EntityCollidable> coll = this.collidesAtWith(platforms, this.pos.x + (double)sign22, this.pos.y);
                if (coll.isEmpty()) {
                    this.pos.x += (double)sign22;
                    this.toMove.x -= (double)sign22;
                } else if (coll.size() == 1 && coll.get(0) instanceof EntityBoxPushable && collidesD) {
                    EntityCollidable ec = coll.get(0);
                    if (!ec.collidesAt(platforms, ec.pos.x + (double)sign22, ec.pos.y)) {
                        ec.pos.x += (double)sign22;
                        this.pos.x += (double)sign22;
                        this.toMove.x -= 1.0 * (double)sign22;
                        this.vel.x /= 2.0;
                        if (!this.didPush && !inWater && Main.rand.nextInt(3) == 0) {
                            PtLand.make(this.ps2, this.pos.Add(12.0, 24.0), this.vel.x < 0.0);
                            this.didPush = true;
                        }
                    } else {
                        this.toMove.x = 0.0;
                        this.vel.x = 0.0;
                    }
                } else {
                    this.toMove.x = 0.0;
                    this.vel.x = 0.0;
                }
            }
            if (!(this.toMove.y >= 0.5) && !(this.toMove.y < -0.5)) continue;
            v = true;
            sign22 = (int)Math.signum(this.toMove.y);
            if (!this.collidesAt(platforms, this.pos.x, this.pos.y + (double)sign22)) {
                this.pos.y += (double)sign22;
                this.toMove.y -= (double)sign22;
                continue;
            }
            if (!(!(this.vel.y > 0.0) || inWater || dir != 0 && this.collidesAt(platforms, this.pos.x + (double)dir, this.pos.y))) {
                int i = 0;
                while ((double)i < this.vel.y) {
                    PtLand.make(this.ps2, this.pos.Add(12.0, 24.0), new Object[0]);
                    ++i;
                }
            }
            this.toMove.y = 0.0;
            this.vel.y = 0.0;
        } while (h || v);
        if (Math.signum(this.frame) != (float)dir && this.frame != 0 && dir != 0) {
            this.frame += dir;
        }
        this.frame += dir;
        if (!(l ^ r) && this.frame != 0) {
            this.frame -= (int)Math.signum(this.frame);
        }
        this.frame = Math2.limit(this.frame, 8);
        if (this.doingSkid) {
            PtSkidJump.make(this.ps, this.pos.Add(12.0, 12.0));
        }
        this.ps.update();
        this.ps2.update();
    }

    protected List<EntityBase> getPlatforms() {
        return Entities.getTypes(EntityWall.class, EntityBox.class);
    }

    @Override
    protected void onRegister() {
        new Renderable(this, 4.9){

            @Override
            protected void onRender(Graphics g) {
                if (!WaterBlur.blur) {
                    EntityPlayer.this.ps.render(g);
                    EntityPlayer.this.ps2.render(g);
                }
            }
        }.create();
        new Renderable(this, 4.8){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
                g.draw((ITextureSupplier)Assets.sPlayerBase, EntityPlayer.this.pos.x, EntityPlayer.this.pos.y);
            }
        }.create();
        new Renderable(this, 4.7){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
                g.pushTransformedClip(EntityPlayer.this.pos.x, EntityPlayer.this.pos.y, 24.0, 24.0);
                g.draw((ITextureSupplier)Assets.sPlayerEye, EntityPlayer.this.pos.x + 6.0 + (double)(EntityPlayer.this.frame * (EntityPlayer.this.frame > 0 ? 1 : 2)), EntityPlayer.this.pos.y + 6.0);
                g.draw((ITextureSupplier)Assets.sPlayerEye, EntityPlayer.this.pos.x + 15.0 + (double)(EntityPlayer.this.frame * (EntityPlayer.this.frame > 0 ? 2 : 1)), EntityPlayer.this.pos.y + 6.0);
                g.popTransformedClip();
            }
        }.create();
        new Renderable(this, 4.6){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
                g.draw((ITextureSupplier)Assets.ssTileBorderThin.getImage(0), EntityPlayer.this.pos.x, EntityPlayer.this.pos.y);
            }
        }.create();
    }

    public class Jumps {
        public int max;
        public int available;

        public Jumps() {
            this.available = this.max = 2;
        }

        public void reset() {
            this.available = this.max;
        }

        public boolean make() {
            if (this.canMake()) {
                --this.available;
                return true;
            }
            return false;
        }

        public boolean canMake() {
            return this.available > 0;
        }

        public boolean firstJump() {
            return this.available == this.max;
        }

        public void fall() {
            if (this.available == this.max) {
                --this.available;
            }
        }
    }
}

