/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.states;

import pl.shockah.Util;
import pl.shockah.glib.AssetLoader;
import pl.shockah.glib.Gamelib;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.logic.standard.GameStandard;
import pl.shockah.glib.state.State;
import pl.shockah.glib.state.View;
import pl.shockah.glib.state.transitions.TransitionThroughColor;
import pl.shockah.ts.Assets;
import pl.shockah.ts.states.StateMenuMain;

public class StateLoading
extends State {
    protected boolean once = true;

    public StateLoading() {
        this.views.add(new View(new Vector2i(960, 720)));
    }

    @Override
    protected void onPreUpdate() {
        if (!this.once) {
            return;
        }
        this.once = false;
        AssetLoader al = Assets.createAssetLoader();
        Graphics g = GameStandard.me.getGraphics();
        while (true) {
            al.update();
            if (al.finished()) break;
            if (Assets.ssLoadingBar != null) {
                g.clear();
                this.drawLoadingBar(g, al.getStatus());
                Gamelib.advanceFrame();
            }
            Util.sleep(1L);
        }
        Assets.setupAssets();
        State.change(new StateMenuMain(), new TransitionThroughColor(0.025f), new TransitionThroughColor(0.025f, true));
    }

    @Override
    protected void onPreTransitionRender(Graphics g) {
        this.drawLoadingBar(g, 1.0);
    }

    private void drawLoadingBar(Graphics g, double status) {
        Vector2i size = this.getDisplaySize();
        g.setColor(Color.White);
        Image image = Assets.ssLoadingBar.getImage(0);
        Image image2 = image.part(0, 0, (int)(image.getWidth() * status), (int)image.getHeight());
        image2.offset.set(Assets.ssLoadingBar.offset);
        g.draw((ITextureSupplier)image2, ((double)size.x - image.getWidth()) / 2.0, (double)(size.y / 2) - image.getHeight() / 2.0);
        g.draw((ITextureSupplier)Assets.ssLoadingBar.getImage(1), ((double)size.x - image.getWidth()) / 2.0, (double)(size.y / 2) - image.getHeight() / 2.0);
    }
}

