/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import pl.shockah.Util;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.logic.standard.Entities;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.entities.EntityBoxGravity;
import pl.shockah.ts.entities.EntityBoxPushable;
import pl.shockah.ts.entities.EntityPlayer;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;

public class EntityBoxFalling
extends EntityBoxPushable {
    protected float falling = -1.0f;

    @Override
    protected void onCreate() {
        super.onCreate();
        this.shape = new Rectangle(this.pos.x, this.pos.y, 24.0, 24.0);
    }

    @Override
    protected void onUpdate() {
        double mod = Game.me.time.getSpeed(this);
        if (mod == 0.0) {
            return;
        }
        if (this.falling == -1.0f && this.collidesAt(Util.getAllOf(Entities.getTypes(EntityPlayer.class, EntityBoxGravity.class), EntityCollidable.class), this.pos.x, this.pos.y - 1.0)) {
            this.falling = 20.0f;
        }
        if (this.falling > 0.0f) {
            this.falling = (float)((double)this.falling - 1.0 * mod);
        }
        if (this.falling <= 0.0f && this.falling > -1.0f) {
            super.onUpdate();
        }
    }

    @Override
    protected void onRegister() {
        new Renderable(this, this.baseDepth - 0.1){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
                g.draw((ITextureSupplier)Assets.ssBoxes.getImage(1), EntityBoxFalling.this.pos.x, EntityBoxFalling.this.pos.y);
            }
        }.create();
        new Renderable(this, this.baseDepth - 0.2){

            @Override
            protected void onRender(Graphics g) {
                g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
                g.draw((ITextureSupplier)Assets.ssTileBorderThin.getImage(0), EntityBoxFalling.this.pos.x, EntityBoxFalling.this.pos.y);
            }
        }.create();
    }
}

