/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities.effects;

import pl.shockah.Math2;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.logic.standard.EntityRenderable;
import pl.shockah.glib.state.State;
import pl.shockah.ts.Assets;
import pl.shockah.ts.gameplay.Game;

public class EffectOverlayTime
extends EntityRenderable {
    public static EffectOverlayTime me = null;
    protected double xx = 0.0;
    public float musicPitch = 1.0f;
    public float a1 = 0.0f;
    public float a2 = 0.0f;

    public EffectOverlayTime() {
        this.baseDepth = -100000.0;
    }

    @Override
    protected void onCreate() {
        me = this;
    }

    @Override
    protected void onUpdate() {
        switch (Game.me.time) {
            case Normal: {
                if (!(this.musicPitch < 1.0f)) break;
                if (this.musicPitch >= 0.0f) {
                    this.a1 -= 0.05f;
                    this.a2 -= 0.05f;
                }
                this.musicPitch += 0.05f;
                break;
            }
            case Slow: {
                if (this.musicPitch < 0.5f) {
                    this.musicPitch += 0.05f;
                    if (this.musicPitch >= 0.0f) {
                        this.a1 += 0.05f;
                        this.a2 -= 0.05f;
                    }
                }
                if (!(this.musicPitch > 0.5f)) break;
                this.musicPitch -= 0.05f;
                this.a1 += 0.05f;
                this.a2 -= 0.05f;
                break;
            }
            case Stop: {
                if (this.musicPitch < 0.0f) {
                    this.musicPitch += 0.05f;
                    break;
                }
                this.musicPitch -= 0.05f;
                this.musicPitch = Math.max(this.musicPitch, 0.0f);
                this.a1 -= 0.05f;
                this.a2 += 0.05f;
            }
        }
        this.a1 = Math2.limit(this.a1, 0.0f, 0.5f);
        this.a2 = Math2.limit(this.a2, 0.0f, 0.5f);
        this.xx = this.musicPitch >= 0.5f ? (this.xx += 2.0) : (this.xx += (double)(this.musicPitch * 4.0f));
        if (this.xx < 0.0) {
            this.xx += (double)Assets.sOverlayTime.getTextureWidth();
        }
        if (this.xx > (double)Assets.sOverlayTime.getTextureWidth()) {
            this.xx -= (double)Assets.sOverlayTime.getTextureWidth();
        }
    }

    @Override
    protected void onRender(Graphics g) {
        int x;
        int y;
        Vector2i size = State.get().getDisplaySize();
        g.toggleAbsolute();
        GL.translated(Game.me.translateV.Negate());
        if (this.a1 > 0.0f) {
            g.setColor(Color.Purple.alpha(this.a1));
            y = 0;
            while (y < size.y) {
                x = (int)(this.xx - (double)Assets.sOverlayTime.getTextureWidth());
                while (x < size.x) {
                    g.draw((ITextureSupplier)Assets.sOverlayTime, (double)x, (double)y);
                    x += Assets.sOverlayTime.getTextureWidth();
                }
                y += Assets.sOverlayTime.getTextureHeight();
            }
        }
        if (this.a2 > 0.0f) {
            g.setColor(Color.White.alpha(this.a2));
            y = 0;
            while (y < size.y) {
                x = (int)(this.xx - (double)Assets.sOverlayTime.getTextureWidth());
                while (x < size.x) {
                    g.draw((ITextureSupplier)Assets.sOverlayTime, (double)x, (double)y);
                    x += Assets.sOverlayTime.getTextureWidth();
                }
                y += Assets.sOverlayTime.getTextureHeight();
            }
        }
        GL.translated(Game.me.translateV);
        g.toggleAbsolute();
    }
}

