/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.ts.entities;

import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.ITextureSupplier;
import pl.shockah.glib.gl.tex.Image;
import pl.shockah.glib.logic.standard.EntityCollidable;
import pl.shockah.ts.Assets;
import pl.shockah.ts.Main;
import pl.shockah.ts.entities.waterblur.IWaterBlur;
import pl.shockah.ts.entities.waterblur.WaterBlur;
import pl.shockah.ts.gameplay.Game;
import pl.shockah.ts.gameplay.ITimeAffected;

public class EntityDiamond
extends EntityCollidable
implements IWaterBlur,
ITimeAffected {
    protected final ERarity rarity;
    protected double sin;

    public EntityDiamond(ERarity rarity) {
        this.baseDepth = 10.0;
        this.rarity = rarity;
        this.sin = Main.rand.nextDouble() * 360.0;
    }

    @Override
    protected void onUpdate() {
        this.sin += 1.3 * Game.me.time.getSpeed(this);
        if (this.sin >= 360.0) {
            this.sin -= 360.0;
        }
    }

    @Override
    protected void onRender(Graphics g) {
        g.setColor(Color.White.alpha(0.33333334f * WaterBlur.blurAlpha));
        g.draw((ITextureSupplier)this.rarity.getImage(), this.pos.x, this.pos.y + Math.sin(Math.toRadians(this.sin - 60.0)) * 4.0);
        g.setColor(Color.White.alpha(WaterBlur.blurAlpha));
        g.draw((ITextureSupplier)this.rarity.getImage(), this.pos.x, this.pos.y + Math.sin(Math.toRadians(this.sin)) * 4.0);
    }

    @Override
    public boolean affectedSlow() {
        return true;
    }

    @Override
    public boolean affectedStop() {
        return true;
    }

    public static enum ERarity {
        Blue(Assets.ssDiamond.getImage(0)),
        Red(Assets.ssDiamond.getImage(1));

        private final Image image;

        private ERarity(Image image) {
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

