/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.font;

import java.util.LinkedList;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2f;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.font.ETextAlign;
import pl.shockah.glib.gl.font.Font;

public final class TextHelper {
    public static CharSequence prepare(CharSequence text) {
        return text.toString().replace("\t", "    ");
    }

    public static CharSequence wordwrap(Font font, CharSequence text, double maxWidth) {
        String[] ss;
        LinkedList<String> ret = new LinkedList<String>();
        String[] stringArray = ss = TextHelper.prepare(text).toString().split("\\r?\\n");
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            s = s.trim();
            while (!s.isEmpty()) {
                String s2 = s;
                if (!((double)font.getWidth(s) > maxWidth)) {
                    ret.add(s);
                    break;
                }
                String[] words = s.split("\\S+");
                String[] nwords = s.split("\\s+");
                int i = words.length;
                while (i >= 0) {
                    String sret = TextHelper.implodeWords(words, nwords, i);
                    if ((double)font.getWidth(sret) <= maxWidth) {
                        s = s.substring(sret.length());
                        ret.add(sret);
                        break;
                    }
                    --i;
                }
                if (!s2.equals(s)) continue;
                ret.add(s);
                break;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : ret) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        return sb;
    }

    private static String implodeWords(String[] words, String[] nwords, int n) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < n) {
            sb.append(words[i]);
            if (i != n - 1) {
                sb.append(nwords[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void draw(Graphics g, Font font, Vector2d v, CharSequence text) {
        TextHelper.draw(g, font, v.x, v.y, text);
    }

    public static void draw(Graphics g, Font font, Vector2f v, CharSequence text) {
        TextHelper.draw(g, font, v.x, v.y, text);
    }

    public static void draw(Graphics g, Font font, Vector2i v, CharSequence text) {
        TextHelper.draw(g, font, v.x, v.y, text);
    }

    public static void draw(Graphics g, Font font, Vector2d v, CharSequence text, ETextAlign align) {
        TextHelper.draw(g, font, v.x, v.y, text, align);
    }

    public static void draw(Graphics g, Font font, Vector2f v, CharSequence text, ETextAlign align) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, text, align);
    }

    public static void draw(Graphics g, Font font, Vector2i v, CharSequence text, ETextAlign align) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, text, align);
    }

    public static void draw(Graphics g, Font font, Vector2d v, CharSequence text, Vector2d alignScale) {
        TextHelper.draw(g, font, v.x, v.y, text, alignScale);
    }

    public static void draw(Graphics g, Font font, Vector2f v, CharSequence text, Vector2d alignScale) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, text, alignScale);
    }

    public static void draw(Graphics g, Font font, Vector2i v, CharSequence text, Vector2d alignScale) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, text, alignScale);
    }

    public static void drawWrapped(Graphics g, Font font, Vector2d v, CharSequence text, double maxWidth) {
        TextHelper.draw(g, font, v.x, v.y, TextHelper.wordwrap(font, text, maxWidth));
    }

    public static void drawWrapped(Graphics g, Font font, Vector2f v, CharSequence text, double maxWidth) {
        TextHelper.draw(g, font, v.x, v.y, TextHelper.wordwrap(font, text, maxWidth));
    }

    public static void drawWrapped(Graphics g, Font font, Vector2i v, CharSequence text, double maxWidth) {
        TextHelper.draw(g, font, v.x, v.y, TextHelper.wordwrap(font, text, maxWidth));
    }

    public static void drawWrapped(Graphics g, Font font, Vector2d v, CharSequence text, ETextAlign align, double maxWidth) {
        TextHelper.draw(g, font, v.x, v.y, TextHelper.wordwrap(font, text, maxWidth), align);
    }

    public static void drawWrapped(Graphics g, Font font, Vector2f v, CharSequence text, ETextAlign align, double maxWidth) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, TextHelper.wordwrap(font, text, maxWidth), align);
    }

    public static void drawWrapped(Graphics g, Font font, Vector2i v, CharSequence text, ETextAlign align, double maxWidth) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, TextHelper.wordwrap(font, text, maxWidth), align);
    }

    public static void drawWrapped(Graphics g, Font font, Vector2d v, CharSequence text, Vector2d alignScale, double maxWidth) {
        TextHelper.draw(g, font, v.x, v.y, TextHelper.wordwrap(font, text, maxWidth), alignScale);
    }

    public static void drawWrapped(Graphics g, Font font, Vector2f v, CharSequence text, Vector2d alignScale, double maxWidth) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, TextHelper.wordwrap(font, text, maxWidth), alignScale);
    }

    public static void drawWrapped(Graphics g, Font font, Vector2i v, CharSequence text, Vector2d alignScale, double maxWidth) {
        TextHelper.draw(g, font, (double)v.x, (double)v.y, TextHelper.wordwrap(font, text, maxWidth), alignScale);
    }

    public static void drawWrapped(Graphics g, Font font, double x, double y, CharSequence text, double maxWidth) {
        TextHelper.draw(g, font, x, y, TextHelper.wordwrap(font, text, maxWidth), ETextAlign.TopLeft);
    }

    public static void drawWrapped(Graphics g, Font font, double x, double y, CharSequence text, ETextAlign align, double maxWidth) {
        TextHelper.draw(g, font, x, y, TextHelper.wordwrap(font, text, maxWidth), align.getScale());
    }

    public static void drawWrapped(Graphics g, Font font, double x, double y, CharSequence text, Vector2d alignScale, double maxWidth) {
        TextHelper.draw(g, font, x, y, TextHelper.wordwrap(font, text, maxWidth), alignScale);
    }

    public static void draw(Graphics g, Font font, double x, double y, CharSequence text) {
        TextHelper.draw(g, font, x, y, text, ETextAlign.TopLeft);
    }

    public static void draw(Graphics g, Font font, double x, double y, CharSequence text, ETextAlign align) {
        TextHelper.draw(g, font, x, y, text, align.getScale());
    }

    public static void draw(Graphics g, Font font, double x, double y, CharSequence text, Vector2d alignScale) {
        String[] ss = TextHelper.prepare(text).toString().split("\\r?\\n");
        Rectangle rect = new Rectangle(0.0, 0.0, 0.0, 0.0);
        double h = font.getHeight();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            double w = font.getWidth(s2);
            if (w > rect.size.x) {
                rect.size.x = w;
            }
            rect.size.y += h;
            ++n2;
        }
        rect.pos.y = rect.size.y * alignScale.y;
        TextHelper.draw(g, font, x, y, rect, ss, alignScale.x);
    }

    private static void draw(Graphics g, Font font, double x, double y, Rectangle rect, String[] ss, double xAlignScale) {
        int i = 0;
        while (i < ss.length) {
            font.draw(g, x + (double)font.getWidth(ss[i]) * xAlignScale, y + rect.pos.y + rect.size.y / (double)ss.length * (double)i, ss[i]);
            ++i;
        }
    }
}

