/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom.vector;

import pl.shockah.Math2;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2i;

public class Vector2f
implements IInterpolatable<Vector2f>,
IVector2 {
    public float x;
    public float y;

    public static Vector2f make(float dist, float angle) {
        return new Vector2f((float)Math2.ldirX(dist, angle), (float)Math2.ldirY(dist, angle));
    }

    public Vector2f() {
        this(0.0f, 0.0f);
    }

    public Vector2f(Vector2f v) {
        this(v.x, v.y);
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector2f)) {
            return false;
        }
        Vector2f v = (Vector2f)o;
        return this.x == v.x && this.y == v.y;
    }

    public String toString() {
        return "[Vector2f: " + this.x + ", " + this.y + "]";
    }

    @Override
    public double Xd() {
        return this.x;
    }

    @Override
    public float Xf() {
        return this.x;
    }

    @Override
    public int Xi() {
        return (int)this.x;
    }

    @Override
    public double Yd() {
        return this.y;
    }

    @Override
    public float Yf() {
        return this.y;
    }

    @Override
    public int Yi() {
        return (int)this.y;
    }

    @Override
    public Vector2f copyMe() {
        return new Vector2f(this);
    }

    @Override
    public Vector2i toInt() {
        return new Vector2i((int)this.x, (int)this.y);
    }

    @Override
    public Vector2f toFloat() {
        return this.copyMe();
    }

    @Override
    public Vector2d toDouble() {
        return new Vector2d(this.x, this.y);
    }

    public Vector2f set(IVector2 v) {
        return this.set(v.Xf(), v.Yf());
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f setX(IVector2 v) {
        return this.setX(v.Xf());
    }

    public Vector2f setX(float x) {
        this.x = x;
        return this;
    }

    public Vector2f setY(IVector2 v) {
        return this.setY(v.Yf());
    }

    public Vector2f setY(float y) {
        this.y = y;
        return this;
    }

    public Vector2f justX() {
        this.y = 0.0f;
        return this;
    }

    public Vector2f JustX() {
        return new Vector2f(this.x, 0.0f);
    }

    public Vector2f justY() {
        this.x = 0.0f;
        return this;
    }

    public Vector2f JustY() {
        return new Vector2f(0.0f, this.y);
    }

    public Vector2f negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f Negate() {
        return new Vector2f(-this.x, -this.y);
    }

    public Vector2f abs() {
        if (this.x < 0.0f) {
            this.x = -this.x;
        }
        if (this.y < 0.0f) {
            this.y = -this.y;
        }
        return this;
    }

    public Vector2f Abs() {
        return new Vector2f(this.x >= 0.0f ? this.x : -this.x, this.y >= 0.0f ? this.y : -this.y);
    }

    public Vector2f add(IVector2 v) {
        return this.add(v.Xf(), v.Yf());
    }

    public Vector2f Add(IVector2 v) {
        return this.Add(v.Xf(), v.Yf());
    }

    public Vector2f add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2f Add(float x, float y) {
        return new Vector2f(this.x + x, this.y + y);
    }

    public Vector2f sub(float x, float y) {
        return this.add(-x, -y);
    }

    public Vector2f Sub(float x, float y) {
        return this.Add(-x, -y);
    }

    public Vector2f sub(IVector2 v) {
        return this.sub(v.Xf(), v.Yf());
    }

    public Vector2f Sub(IVector2 v) {
        return this.Sub(v.Xf(), v.Yf());
    }

    public Vector2f scale(float scale) {
        return this.scale(scale, scale);
    }

    public Vector2f Scale(float scale) {
        return this.Scale(scale, scale);
    }

    public Vector2f scale(float scaleH, float scaleV) {
        this.x *= scaleH;
        this.y *= scaleV;
        return this;
    }

    public Vector2f Scale(float scaleH, float scaleV) {
        return new Vector2f(this.x * scaleH, this.y * scaleV);
    }

    public Vector2f scale(IVector2 v) {
        return this.scale(v.Xf(), v.Yf());
    }

    public Vector2f Scale(IVector2 v) {
        return this.Scale(v.Xf(), v.Yf());
    }

    public Vector2f div(float scale) {
        return this.div(scale, scale);
    }

    public Vector2f Div(float scale) {
        return this.Div(scale, scale);
    }

    public Vector2f div(float scaleH, float scaleV) {
        return this.scale(1.0f / scaleH, 1.0f / scaleV);
    }

    public Vector2f Div(float scaleH, float scaleV) {
        return this.Scale(1.0f / scaleH, 1.0f / scaleV);
    }

    public Vector2f div(IVector2 v) {
        return this.div(v.Xf(), v.Yf());
    }

    public Vector2f Div(IVector2 v) {
        return this.Div(v.Xf(), v.Yf());
    }

    public Vector2f Vector(IVector2 v) {
        return new Vector2f(v.Xf() - this.x, v.Yf() - this.y);
    }

    public float lengthSquared() {
        return (float)(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float distanceSquared(IVector2 v) {
        return (float)(Math.pow(v.Xf() - this.x, 2.0) + Math.pow(v.Yf() - this.y, 2.0));
    }

    public float distance(IVector2 v) {
        return (float)Math.sqrt(this.distanceSquared(v));
    }

    @Override
    public double direction() {
        return new Vector2f().direction(this);
    }

    @Override
    public double direction(IVector2 v) {
        return Math.toDegrees(Math.atan2(this.y - v.Yf(), v.Xf() - this.x));
    }

    @Override
    public double deltaAngle(IVector2 v) {
        return this.deltaAngle(v.direction());
    }

    @Override
    public double deltaAngle(double angle) {
        double r;
        double a = this.direction();
        while (angle <= -180.0) {
            angle += 360.0;
        }
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (a <= -180.0) {
            a += 360.0;
        }
        while (a > 180.0) {
            a -= 360.0;
        }
        return r + (double)((r = angle - a) > 180.0 ? -360 : (r < -180.0 ? 360 : 0));
    }

    @Override
    public Vector2f interpolate(Vector2f v, double d, Interpolate method) {
        return new Vector2f(method.interpolate(this.x, v.x, d), method.interpolate(this.y, v.y, d));
    }
}

