/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom;

import org.lwjgl.opengl.GL11;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.Circle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.polygon.IPolygonable;
import pl.shockah.glib.geom.polygon.Polygon;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.color.Color;

public class Rectangle
extends Shape
implements IPolygonable,
IInterpolatable<Rectangle> {
    public Vector2d pos;
    public Vector2d size;

    public Rectangle(double w, double h) {
        this(new Vector2d(), w, h);
    }

    public Rectangle(IVector2 size) {
        this(new Vector2d(), size);
    }

    public Rectangle(double x, double y, double w, double h) {
        this(new Vector2d(x, y), new Vector2d(w, h));
    }

    public Rectangle(double x, double y, IVector2 size) {
        this(new Vector2d(x, y), size);
    }

    public Rectangle(IVector2 pos, double w, double h) {
        this(pos, new Vector2d(w, h));
    }

    public Rectangle(IVector2 pos, IVector2 size) {
        this.pos = pos.toDouble();
        this.size = size.toDouble();
    }

    public Rectangle(Rectangle rect) {
        this.pos = rect.pos.copyMe();
        this.size = rect.size.copyMe();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Rectangle)) {
            return false;
        }
        Rectangle r = (Rectangle)other;
        return this.pos.equals(r.pos) && this.size.equals(r.size);
    }

    public String toString() {
        return String.format("[Rectangle: pos %s, size %s]", this.pos, this.size);
    }

    @Override
    public Shape copy() {
        return this.copyMe();
    }

    @Override
    public Rectangle copyMe() {
        return new Rectangle(this);
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this);
    }

    @Override
    public Vector2d translate(double x, double y) {
        this.pos.add(x, y);
        return new Vector2d(x, y);
    }

    @Override
    public Vector2d translateTo(double x, double y) {
        Vector2d v = new Vector2d(x - this.pos.x, y - this.pos.y);
        this.pos.x = x;
        this.pos.y = y;
        return v;
    }

    @Override
    protected boolean collides(Shape shape, boolean secondTry) {
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            Vector2d v = this.pos.Add(this.size.Div(2.0)).sub(rect.pos.Add(rect.size.Div(2.0))).abs().sub(this.size.Div(2.0).add(rect.size.Div(2.0)));
            return v.x < 0.0 && v.y < 0.0;
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            return circle.pos.Sub(circle.pos.Sub(this.pos.Add(this.size.Div(2.0))).sub(this.size.Div(2.0))).lengthSquared() - Math.pow(circle.radius, 2.0) < 0.0;
        }
        return super.collides(shape);
    }

    @Override
    public Polygon asPolygon() {
        return new Polygon().addPoint(this.pos).addPoint(this.pos.add(this.size.justX())).addPoint(this.pos.add(this.size)).addPoint(this.pos.add(this.size.justY()));
    }

    @Override
    public void draw(Graphics g, boolean filled) {
        g.preDraw();
        GL.unbindTexture();
        if (filled) {
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)this.pos.x, (double)this.pos.y);
            GL11.glVertex2d((double)(this.pos.x + this.size.x), (double)this.pos.y);
            GL11.glVertex2d((double)(this.pos.x + this.size.x), (double)(this.pos.y + this.size.y));
            GL11.glVertex2d((double)this.pos.x, (double)(this.pos.y + this.size.y));
            GL11.glEnd();
        } else {
            GL11.glBegin((int)3);
            GL11.glVertex2d((double)this.pos.x, (double)this.pos.y);
            GL11.glVertex2d((double)(this.pos.x + this.size.x - 1.0), (double)this.pos.y);
            GL11.glVertex2d((double)(this.pos.x + this.size.x - 1.0), (double)(this.pos.y + this.size.y - 1.0));
            GL11.glVertex2d((double)this.pos.x, (double)(this.pos.y + this.size.y - 1.0));
            GL11.glVertex2d((double)this.pos.x, (double)this.pos.y);
            GL11.glEnd();
        }
    }

    public void drawMulticolor(Graphics g, boolean filled, Color cTopLeft, Color cTopRight, Color cBottomLeft, Color cBottomRight) {
        g.preDraw();
        GL.unbindTexture();
        if (filled) {
            GL11.glBegin((int)7);
            GL.bind(cTopLeft);
            GL11.glVertex2d((double)this.pos.x, (double)this.pos.y);
            GL.bind(cTopRight);
            GL11.glVertex2d((double)(this.pos.x + this.size.x), (double)this.pos.y);
            GL.bind(cBottomRight);
            GL11.glVertex2d((double)(this.pos.x + this.size.x), (double)(this.pos.y + this.size.y));
            GL.bind(cBottomLeft);
            GL11.glVertex2d((double)this.pos.x, (double)(this.pos.y + this.size.y));
            GL11.glEnd();
        } else {
            GL11.glBegin((int)3);
            GL.bind(cTopLeft);
            GL11.glVertex2d((double)this.pos.x, (double)this.pos.y);
            GL.bind(cTopRight);
            GL11.glVertex2d((double)(this.pos.x + this.size.x - 1.0), (double)this.pos.y);
            GL.bind(cBottomRight);
            GL11.glVertex2d((double)(this.pos.x + this.size.x - 1.0), (double)(this.pos.y + this.size.y - 1.0));
            GL.bind(cBottomLeft);
            GL11.glVertex2d((double)this.pos.x, (double)(this.pos.y + this.size.y - 1.0));
            GL.bind(cTopLeft);
            GL11.glVertex2d((double)this.pos.x, (double)this.pos.y);
            GL11.glEnd();
        }
    }

    @Override
    public Rectangle interpolate(Rectangle r, double d, Interpolate method) {
        return new Rectangle(this.pos.interpolate(r.pos, d, method), this.size.interpolate(r.size, d, method));
    }
}

