/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom;

import pl.shockah.Math2;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.Rectangle;
import pl.shockah.glib.geom.Shape;
import pl.shockah.glib.geom.polygon.IPolygonable;
import pl.shockah.glib.geom.polygon.Polygon;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.gl.Graphics;

public class Ellipse
extends Shape
implements IPolygonable,
IInterpolatable<Ellipse> {
    public Vector2d pos;
    public Vector2d radius;
    protected Vector2d lastPos;
    protected int lastPrecision = -1;
    protected Polygon lastPoly = null;

    public Ellipse(double x, double y, double radiusH, double radiusV) {
        this.pos = new Vector2d(x, y);
        this.radius = new Vector2d(radiusH, radiusV);
    }

    public Ellipse(double x, double y, Vector2d radius) {
        this.pos = new Vector2d(x, y);
        this.radius = radius;
    }

    public Ellipse(Vector2d pos, double radiusH, double radiusV) {
        this.pos = pos;
        this.radius = new Vector2d(radiusH, radiusV);
    }

    public Ellipse(Vector2d pos, Vector2d radius) {
        this.pos = pos;
        this.radius = radius;
    }

    public Ellipse(Ellipse ellipse) {
        this.pos = new Vector2d(ellipse.pos);
        this.radius = new Vector2d(ellipse.radius);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Ellipse)) {
            return false;
        }
        Ellipse e = (Ellipse)other;
        return this.pos.equals(e.pos) && this.radius.equals(e.radius);
    }

    public String toString() {
        return String.format("[Ellipse: pos %s, radius %s]", this.pos, this.radius);
    }

    @Override
    public Shape copy() {
        return this.copyMe();
    }

    @Override
    public Ellipse copyMe() {
        return new Ellipse(this);
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.pos.x - this.radius.x, this.pos.y - this.radius.y, this.radius.x * 2.0, this.radius.y * 2.0);
    }

    @Override
    public Vector2d translate(double x, double y) {
        this.pos.x += x;
        this.pos.y += y;
        return new Vector2d(x, y);
    }

    @Override
    public Vector2d translateTo(double x, double y) {
        Vector2d v = new Vector2d(x - this.pos.x, y - this.pos.y);
        this.pos.x = x;
        this.pos.y = y;
        return v;
    }

    @Override
    public Polygon asPolygon() {
        return this.asPolygon((int)Math.ceil(Math.PI * (this.radius.x + this.radius.y) / 4.0));
    }

    public Polygon asPolygon(int precision) {
        if (this.lastPoly != null && this.lastPoly.getPointCount() == precision && this.lastPrecision == precision && this.lastPos.equals(this.pos)) {
            return this.lastPoly;
        }
        Polygon.NoHoles p = new Polygon.NoHoles();
        int i = 0;
        while (i < precision) {
            p.addPoint(new Vector2d(Math2.ldirX(this.radius.x, 360.0 / (double)precision * (double)i), Math2.ldirY(this.radius.y, 360.0 / (double)precision * (double)i)).add(this.pos));
            ++i;
        }
        this.lastPos = this.pos;
        this.lastPrecision = precision;
        this.lastPoly = p;
        return this.lastPoly;
    }

    @Override
    public void draw(Graphics g, boolean filled) {
        this.asPolygon().draw(g, filled);
    }

    public void draw(Graphics g, boolean filled, int precision) {
        this.asPolygon(precision).draw(g, filled);
    }

    @Override
    public Ellipse interpolate(Ellipse e, double d, Interpolate method) {
        return new Ellipse(this.pos.interpolate(e.pos, d, method), this.radius.interpolate(e.radius, d, method));
    }
}

