/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import pl.shockah.BinBufferSerializer;
import pl.shockah.IBinBufferSerializable;

public class BinBuffer {
    protected byte[] buffer;
    protected int pos = 0;
    protected int bytes = 0;

    public BinBuffer() {
        this(8192);
    }

    public BinBuffer(int startBytes) {
        this.buffer = new byte[startBytes];
    }

    public BinBuffer(ByteBuffer bb) {
        this(bb, false);
    }

    public BinBuffer(ByteBuffer bb, boolean filled) {
        if (filled) {
            this.setByteBuffer(bb);
            this.setPos(this.bytes);
        } else {
            this.buffer = bb.array();
        }
    }

    public BinBuffer(byte[] bytes) {
        this(bytes, false);
    }

    public BinBuffer(byte[] bytes, boolean filled) {
        if (filled) {
            this.bytes = bytes.length;
        }
        this.buffer = bytes;
    }

    protected void increaseBufferSize() {
        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = Math.min(Math.max(pos, 0), this.bytes);
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.bytes;
    }

    public int getSizeReal() {
        return this.buffer.length;
    }

    public int bytesLeft() {
        return this.bytes - this.pos;
    }

    public void clear() {
        this.pos = 0;
        this.bytes = 0;
    }

    public BinBuffer writeByte(int value) {
        int val;
        if (this.pos > this.buffer.length - 1) {
            this.increaseBufferSize();
        }
        if (this.pos > this.bytes - 1) {
            ++this.bytes;
        }
        if ((val = value % 256) < 0) {
            val += 256;
        }
        this.buffer[this.pos++] = (byte)val;
        return this;
    }

    protected void writeByte(long value) {
        long val = value % 256L;
        if (val < 0L) {
            val += 256L;
        }
        this.writeByte((int)val);
    }

    public BinBuffer writeUXBytes(long value, int x) {
        int i = 0;
        while (i < x) {
            this.writeByte(value);
            value >>= 8;
            ++i;
        }
        return this;
    }

    public BinBuffer writeXBytes(long value, int x) {
        this.writeUXBytes(value + ((long)Math.pow(256.0, x) >> 1), x);
        return this;
    }

    public BinBuffer writeSByte(int value) {
        this.writeXBytes(value, 1);
        return this;
    }

    public BinBuffer writeUShort(int value) {
        this.writeUXBytes(value, 2);
        return this;
    }

    public BinBuffer writeShort(int value) {
        this.writeXBytes(value, 2);
        return this;
    }

    public BinBuffer writeUInt(long value) {
        this.writeUXBytes(value, 4);
        return this;
    }

    public BinBuffer writeInt(int value) {
        this.writeXBytes(value, 4);
        return this;
    }

    public BinBuffer writeFloat(float value) {
        this.writeUXBytes(Float.floatToRawIntBits(value), 4);
        return this;
    }

    public BinBuffer writeDouble(double value) {
        this.writeUXBytes(Double.doubleToRawLongBits(value), 8);
        return this;
    }

    public BinBuffer writeChars(String text) {
        int i = 0;
        while (i < text.length()) {
            this.writeByte(text.charAt(i));
            ++i;
        }
        return this;
    }

    public BinBuffer writeUChars(String text) {
        int i = 0;
        while (i < text.length()) {
            this.writeUShort(text.charAt(i));
            ++i;
        }
        return this;
    }

    public BinBuffer writeString(String text) {
        this.writeUInt(text.length());
        this.writeChars(text);
        return this;
    }

    public BinBuffer writeUString(String text) {
        this.writeUInt(text.length());
        this.writeUChars(text);
        return this;
    }

    public BinBuffer writeJavaString(String text) {
        byte[] bytes = text.getBytes(Charset.forName("UTF-8"));
        this.writeUShort(bytes.length);
        this.writeBytes(bytes);
        return this;
    }

    public BinBuffer writeBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.writeSByte(bytes[i]);
            ++i;
        }
        return this;
    }

    public BinBuffer writeObject(IBinBufferSerializable ibbs) {
        ibbs.getSerializer().write(this, ibbs);
        return this;
    }

    public int readByte() {
        if (this.pos > this.buffer.length - 1) {
            return 0;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public long readUXBytes(int x) {
        long value = 0L;
        int i = 0;
        while (i < x) {
            value = (long)((double)value + (double)this.readByte() * Math.pow(256.0, i));
            ++i;
        }
        return value;
    }

    public long readXBytes(int x) {
        return this.readUXBytes(x) - ((long)Math.pow(256.0, x) >> 1);
    }

    public int readSByte() {
        return (int)this.readXBytes(1);
    }

    public int readUShort() {
        return (int)this.readUXBytes(2);
    }

    public int readShort() {
        return (int)this.readXBytes(2);
    }

    public long readUInt() {
        return this.readUXBytes(4);
    }

    public int readInt() {
        return (int)this.readXBytes(4);
    }

    public float readFloat() {
        return Float.intBitsToFloat((int)this.readUXBytes(4));
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readUXBytes(8));
    }

    public String readChars(int length) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < length) {
            s.append((char)this.readByte());
            ++i;
        }
        return s.toString();
    }

    public String readUChars(int length) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < length) {
            s.append((char)this.readUShort());
            ++i;
        }
        return s.toString();
    }

    public String readString() {
        return this.readChars((int)this.readUInt());
    }

    public String readUString() {
        return this.readUChars((int)this.readUInt());
    }

    public String readJavaString() {
        return new String(this.readBytes(this.readUShort()), Charset.forName("UTF-8"));
    }

    public byte[] readBytes(int bytes) {
        byte[] ret = new byte[bytes];
        int i = 0;
        while (i < bytes) {
            ret[i] = (byte)this.readSByte();
            ++i;
        }
        return ret;
    }

    public IBinBufferSerializable readObject(BinBufferSerializer bbs) {
        return bbs.read(this);
    }

    public void fillByte(int value) {
        int i = 0;
        while (i < this.getSizeReal()) {
            this.writeByte(value);
            ++i;
        }
    }

    public BinBuffer copy() {
        return this.copy(this.bytesLeft());
    }

    public BinBuffer copy(int bytes) {
        BinBuffer binb = new BinBuffer();
        int i = 0;
        while (i < bytes) {
            binb.writeByte(this.readByte());
            ++i;
        }
        return binb;
    }

    public void writeBinBuffer(BinBuffer binb) {
        this.writeBinBuffer(binb, binb.bytesLeft());
    }

    public void writeBinBuffer(BinBuffer binb, int bytes) {
        int i = 0;
        while (i < bytes) {
            this.writeByte(binb.readByte());
            ++i;
        }
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.buffer, this.getPos(), this.getSize()).asReadOnlyBuffer();
    }

    public BinBuffer setByteBuffer(ByteBuffer bb) {
        this.buffer = bb.array();
        this.bytes = bb.limit();
        return this;
    }
}

