/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.logic.standard;

import java.util.LinkedList;
import java.util.List;
import pl.shockah.SortedLinkedList;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.logic.IGame;
import pl.shockah.glib.logic.standard.EntityBase;
import pl.shockah.glib.logic.standard.Renderable;
import pl.shockah.glib.state.State;

public class GameStandard
implements IGame {
    public static GameStandard me = null;
    private static Graphics g = new Graphics();
    protected final List<EntityBase> entities = new LinkedList<EntityBase>();
    protected final List<EntityBase> entitiesAdd = new LinkedList<EntityBase>();
    protected final List<EntityBase> entitiesRemove = new LinkedList<EntityBase>();
    protected final List<Renderable> renderable = new SortedLinkedList<Renderable>();
    protected final List<Renderable> renderableAdd = new SortedLinkedList<Renderable>();
    protected final List<Renderable> renderableRemove = new SortedLinkedList<Renderable>();

    public GameStandard() {
        me = this;
    }

    @Override
    public void reset() {
        this.entities.clear();
        this.entitiesAdd.clear();
        this.entitiesRemove.clear();
        this.renderable.clear();
        this.renderableAdd.clear();
        this.renderableRemove.clear();
    }

    public Graphics getGraphics() {
        return g;
    }

    @Override
    public void gameLoop() {
        State state = State.get();
        state.updateTransition();
        if (State.get() == null) {
            return;
        }
        state.preUpdate();
        if (state.shouldTransitionUpdate()) {
            this.entities.addAll(this.entitiesAdd);
            this.entities.removeAll(this.entitiesRemove);
            this.entitiesAdd.clear();
            this.entitiesRemove.clear();
            for (EntityBase e : this.entities) {
                e.update();
            }
        }
        if (State.get() == null) {
            return;
        }
        Graphics.getDefaultBlendMode().apply();
        g.clearClip();
        g.clearTransformedClip();
        g.clearTransformations();
        state.preRender(g);
        state.renderTransitionPre(g);
        if (state.shouldTransitionRender(g)) {
            this.renderable.removeAll(this.renderableRemove);
            this.renderable.addAll(this.renderableAdd);
            this.renderableRemove.clear();
            this.renderableAdd.clear();
            g.clear();
            for (Renderable r : this.renderable) {
                r.render(g);
            }
        }
        state.preTransitionRender(g);
        state.renderTransition(g);
        state.postRender(g);
        GL.loadIdentity();
    }
}

