/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.logic.standard;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import pl.shockah.glib.logic.standard.EntityBase;
import pl.shockah.glib.logic.standard.GameStandard;
import pl.shockah.glib.logic.standard.IEntityFilter;
import pl.shockah.glib.logic.standard.Renderable;

public final class Entities {
    public static List<EntityBase> get() {
        return Collections.unmodifiableList(GameStandard.me.entities);
    }

    public static List<Renderable> getRenderable() {
        return Collections.unmodifiableList(GameStandard.me.renderable);
    }

    public static <T extends EntityBase> List<T> getType(IEntityFilter filter, Class<T> cls) {
        LinkedList<EntityBase> list = new LinkedList<EntityBase>();
        for (EntityBase entity : GameStandard.me.entities) {
            boolean b = true;
            if (b && filter != null && !filter.accept(entity)) {
                b = false;
            }
            if (b && cls != null && !cls.isAssignableFrom(entity.getClass())) {
                b = false;
            }
            if (!b) continue;
            list.add(entity);
        }
        return list;
    }

    public static <T extends EntityBase> List<T> getType(Class<T> cls) {
        return Entities.getType(null, cls);
    }

    @SafeVarargs
    public static List<EntityBase> getTypes(IEntityFilter filter, Class<? extends EntityBase> ... entityClasses) {
        LinkedList<EntityBase> list = new LinkedList<EntityBase>();
        for (EntityBase entity : GameStandard.me.entities) {
            boolean b = true;
            if (b && filter != null && !filter.accept(entity)) {
                b = false;
            }
            if (b && entityClasses.length != 0) {
                b = false;
                Class<? extends EntityBase>[] classArray = entityClasses;
                int n = entityClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends EntityBase> cls = classArray[n2];
                    if (cls.isAssignableFrom(entity.getClass())) {
                        b = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!b) continue;
            list.add(entity);
        }
        return list;
    }

    @SafeVarargs
    public static List<EntityBase> getTypes(Class<? extends EntityBase> ... entityClasses) {
        return Entities.getTypes(null, entityClasses);
    }
}

