/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.tex.EResizeFilter;
import pl.shockah.glib.gl.tex.TextureLoader;

public class Texture {
    private final int texId;
    private final int width;
    private final int height;
    private final int widthFold;
    private final int heightFold;
    private boolean disposed = false;

    public static Texture load(Path path) throws FileNotFoundException, IOException {
        return Texture.load(path.toFile());
    }

    public static Texture load(Path path, String format) throws FileNotFoundException, IOException {
        return Texture.load(path.toFile(), format);
    }

    public static Texture load(File file) throws FileNotFoundException, IOException {
        String[] spl = file.getName().split("\\.");
        return Texture.load(file, spl[spl.length - 1].toUpperCase());
    }

    public static Texture load(File file, String format) throws FileNotFoundException, IOException {
        return Texture.load(new BufferedInputStream(new FileInputStream(file)), format);
    }

    public static Texture load(String internalPath) throws IOException {
        String[] spl = internalPath.split("\\.");
        return Texture.load(internalPath, spl[spl.length - 1].toUpperCase());
    }

    public static Texture load(String internalPath, String format) throws IOException {
        return Texture.load(new BufferedInputStream(Texture.class.getClassLoader().getResourceAsStream(internalPath)), format);
    }

    public static Texture load(InputStream is, String format) throws IOException {
        if (format == null) {
            for (TextureLoader tl : TextureLoader.getAll()) {
                try {
                    Texture tex = tl.load(is);
                    if (tex == null) continue;
                    return tex;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException("Unsupported image format.");
        }
        TextureLoader tl = TextureLoader.getTextureLoader(format);
        if (tl == null) {
            throw new UnsupportedOperationException("Unsupported image format: " + format + ".");
        }
        return tl.load(is);
    }

    public static Vector2i get2Fold(IVector2 v) {
        return Texture.get2Fold(v.Xi(), v.Yi());
    }

    public static Vector2i get2Fold(int x, int y) {
        int xx = 2;
        int yy = 2;
        while (x > xx) {
            xx <<= 1;
        }
        while (y > yy) {
            yy <<= 1;
        }
        return new Vector2i(xx, yy);
    }

    public Texture(int texId, int width, int height) {
        this.texId = texId;
        this.width = width;
        this.height = height;
        Vector2i fold = Texture.get2Fold(width, height);
        this.widthFold = fold.x;
        this.heightFold = fold.y;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Texture)) {
            return false;
        }
        Texture tex = (Texture)other;
        return tex.texId == this.texId;
    }

    public int getID() {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        return this.texId;
    }

    public Vector2i getSize() {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        return new Vector2i(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        return this.width;
    }

    public int getHeight() {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        return this.height;
    }

    public int getWidthFold() {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        return this.widthFold;
    }

    public int getHeightFold() {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        return this.heightFold;
    }

    public void setResizeFilter(EResizeFilter resizeFilter) {
        if (this.disposed) {
            throw new IllegalStateException("Texture already disposed");
        }
        GL.bind(this);
        resizeFilter.set();
    }

    public boolean disposed() {
        return this.disposed;
    }

    public void dispose() {
        GL11.glDeleteTextures((int)this.texId);
        this.disposed = true;
    }

    protected void finalize() {
        this.dispose();
    }
}

