/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.json;

import java.util.Map;
import pl.shockah.json.JSONList;
import pl.shockah.json.JSONObject;
import pl.shockah.json.JSONPrinter;

public class JSONPrettyPrinter
extends JSONPrinter {
    @Override
    public String print(JSONObject j) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (!j.isEmpty()) {
            sb.append('\n');
            this.indent(sb, 1);
        }
        this.print(sb, j, 1);
        if (!j.isEmpty()) {
            sb.append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String print(JSONList<?> j) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (!j.isEmpty()) {
            sb.append('\n');
            this.indent(sb, 1);
        }
        this.print(sb, j, false, 1);
        if (!j.isEmpty()) {
            sb.append('\n');
        }
        sb.append(']');
        return sb.toString();
    }

    protected void print(StringBuilder sb, JSONObject j, int indent) {
        boolean f = true;
        for (Map.Entry<String, Object> entry : j.entries()) {
            Object j2;
            if (!f) {
                sb.append(",\n");
                this.indent(sb, indent);
            }
            sb.append('\"');
            sb.append(this.escapeString(entry.getKey()));
            sb.append("\": ");
            Object o = entry.getValue();
            if (o == null) {
                sb.append("null");
            } else if (o instanceof Boolean) {
                sb.append("" + o);
            } else if (o instanceof Number) {
                sb.append("" + o);
            } else if (o instanceof String) {
                sb.append(String.valueOf('\"') + this.escapeString("" + o) + '\"');
            } else if (o instanceof JSONObject) {
                j2 = (JSONObject)o;
                sb.append('{');
                if (!((JSONObject)j2).isEmpty()) {
                    sb.append('\n');
                    this.indent(sb, indent + 1);
                }
                this.print(sb, (JSONObject)j2, indent + 1);
                if (!((JSONObject)j2).isEmpty()) {
                    sb.append('\n');
                    this.indent(sb, indent);
                }
                sb.append('}');
            } else if (o instanceof JSONList) {
                boolean b;
                j2 = (JSONList)o;
                sb.append('[');
                boolean bl = b = ((JSONList)j2).holdsBooleans() || ((JSONList)j2).holdsNumbers() || ((JSONList)j2).size() == 1 && ((JSONList)j2).isNull(0);
                if (!((JSONList)j2).isEmpty() && !b) {
                    sb.append('\n');
                    this.indent(sb, indent + 1);
                }
                this.print(sb, (JSONList<?>)j2, b, indent + 1);
                if (!((JSONList)j2).isEmpty() && !b) {
                    sb.append('\n');
                    this.indent(sb, indent);
                }
                sb.append(']');
            }
            f = false;
        }
    }

    protected void print(StringBuilder sb, JSONList<?> j, boolean noNewLines, int indent) {
        boolean f = true;
        for (Object o : j) {
            Object j2;
            if (!f) {
                if (noNewLines) {
                    sb.append(", ");
                } else {
                    sb.append(",\n");
                    this.indent(sb, indent);
                }
            }
            if (o == null) {
                sb.append("null");
            } else if (o instanceof Boolean) {
                sb.append("" + o);
            } else if (o instanceof Number) {
                sb.append("" + o);
            } else if (o instanceof String) {
                sb.append(String.valueOf('\"') + this.escapeString("" + o) + '\"');
            } else if (o instanceof JSONObject) {
                j2 = (JSONObject)o;
                sb.append('{');
                if (!((JSONObject)j2).isEmpty()) {
                    sb.append('\n');
                    this.indent(sb, indent + 1);
                }
                this.print(sb, (JSONObject)j2, indent + 1);
                if (!((JSONObject)j2).isEmpty()) {
                    sb.append('\n');
                    this.indent(sb, indent);
                }
                sb.append('}');
            } else if (o instanceof JSONList) {
                boolean b;
                j2 = (JSONList)o;
                sb.append('[');
                boolean bl = b = ((JSONList)j2).holdsBooleans() || ((JSONList)j2).holdsNumbers() || ((JSONList)j2).size() == 1 && ((JSONList)j2).isNull(0);
                if (!((JSONList)j2).isEmpty() && !b) {
                    sb.append('\n');
                    this.indent(sb, indent + 1);
                }
                this.print(sb, (JSONList<?>)j2, b, indent + 1);
                if (!((JSONList)j2).isEmpty() && !b) {
                    sb.append('\n');
                    this.indent(sb, indent);
                }
                sb.append(']');
            }
            f = false;
        }
    }

    protected void indent(StringBuilder sb, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append('\t');
            ++i;
        }
    }
}

