/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.tex;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.geom.vector.Vector2i;
import pl.shockah.glib.gl.GL;
import pl.shockah.glib.gl.tex.EResizeFilter;
import pl.shockah.glib.gl.tex.Texture;
import pl.shockah.glib.gl.tex.TextureLoader;

public class ImageIOTextureLoader
extends TextureLoader {
    protected static ColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    protected static ColorModel glColorModel;

    static {
        int[] nArray = new int[4];
        nArray[0] = 8;
        nArray[1] = 8;
        nArray[2] = 8;
        glColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, false, false, 1, 0);
    }

    public ImageIOTextureLoader(String ... formats) {
        super(formats);
    }

    @Override
    public Texture load(InputStream is) throws IOException {
        BufferedImage bi = ImageIO.read(is);
        Vector2i fold = Texture.get2Fold(bi.getWidth(), bi.getHeight());
        ByteBuffer bb = this.convertImageData(bi, fold);
        int texId = GL11.glGenTextures();
        Texture texture = new Texture(texId, bi.getWidth(), bi.getHeight());
        texture.setResizeFilter(EResizeFilter.Linear);
        GL.bind(texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)fold.x, (int)fold.y, (int)0, (int)(bi.getColorModel().hasAlpha() ? 6408 : 6407), (int)5121, (ByteBuffer)bb);
        return texture;
    }

    private ByteBuffer convertImageData(BufferedImage bi, Vector2i fold) {
        boolean premultiplied = bi.getColorModel().hasAlpha() && this.settings.containsKey("toPremultiplied") && (Boolean)this.settings.get("toPremultiplied") != false;
        WritableRaster raster = Raster.createInterleavedRaster(0, fold.x, fold.y, bi.getColorModel().hasAlpha() ? 4 : 3, null);
        BufferedImage texImage = new BufferedImage(bi.getColorModel().hasAlpha() ? glAlphaColorModel : glColorModel, raster, premultiplied, new Hashtable());
        Graphics g = texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, fold.x, fold.y);
        g.drawImage(bi, 0, 0, null);
        byte[] data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
        ByteBuffer bb = ByteBuffer.allocateDirect(data.length);
        bb.order(ByteOrder.nativeOrder());
        bb.put(data, 0, data.length);
        bb.flip();
        return bb;
    }
}

