/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl.color;

import pl.shockah.glib.gl.color.Color;

public final class ColorbMutable
extends Color {
    public byte r;
    public byte g;
    public byte b;
    public byte a;

    public ColorbMutable(int v) {
        this(v, 255);
    }

    public ColorbMutable(int v, int a) {
        this(v, v, v, a);
    }

    public ColorbMutable(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ColorbMutable(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
    }

    public ColorbMutable(float v) {
        this((int)(v * 255.0f));
    }

    public ColorbMutable(float v, float a) {
        this((int)(v * 255.0f), (int)(v * 255.0f));
    }

    public ColorbMutable(float r, float g, float b) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public ColorbMutable(float r, float g, float b, float a) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    @Override
    public int R() {
        return this.r & 0xFF;
    }

    @Override
    public int G() {
        return this.g & 0xFF;
    }

    @Override
    public int B() {
        return this.b & 0xFF;
    }

    @Override
    public int A() {
        return this.a & 0xFF;
    }

    @Override
    public float Rf() {
        return (float)this.R() / 255.0f;
    }

    @Override
    public float Gf() {
        return (float)this.G() / 255.0f;
    }

    @Override
    public float Bf() {
        return (float)this.B() / 255.0f;
    }

    @Override
    public float Af() {
        return (float)this.A() / 255.0f;
    }

    @Override
    public void copy(Color color) {
        this.r = (byte)color.R();
        this.g = (byte)color.G();
        this.b = (byte)color.B();
        this.a = (byte)color.A();
    }
}

