/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.gl;

import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import pl.shockah.glib.Debug;
import pl.shockah.glib.Gamelib;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.gl.Graphics;
import pl.shockah.glib.gl.Shader;
import pl.shockah.glib.gl.Surface;
import pl.shockah.glib.gl.color.Color;
import pl.shockah.glib.gl.tex.Texture;

public final class GL {
    private static boolean flipped = false;
    private static int pushed = 0;
    private static Texture boundTexture = null;
    private static Surface boundSurface = null;
    private static Shader boundShader = null;
    private static Color boundColor = null;
    private static float thickness = 1.0f;
    private static boolean[] masking = new boolean[4];

    static {
        int i = 0;
        while (i < masking.length) {
            GL.masking[i] = true;
            ++i;
        }
    }

    public static void setup() {
        GL11.glEnable((int)2848);
    }

    public static void initDisplay(int width, int height) {
        GL.initDisplay(width, height, true);
    }

    public static void initDisplay(int width, int height, boolean resetBlending) {
        if (resetBlending) {
            Graphics.getDefaultBlendMode().apply();
            GL.bind(Color.White);
        }
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public static void enterOrtho(int width, int height) {
        GL.enterOrtho(width, height, true);
    }

    public static void enterOrtho(int width, int height, boolean flipped) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)(flipped ? height : 0), (double)(flipped ? 0 : height), (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
        GL.flipped = flipped;
    }

    public static boolean flipped() {
        return flipped;
    }

    public static void colorMask(boolean r, boolean g, boolean b, boolean a) {
        if (masking[0] != r || masking[1] != g || masking[2] != b || masking[3] != a) {
            GL.masking[0] = r;
            GL.masking[1] = g;
            GL.masking[2] = b;
            GL.masking[3] = a;
            GL11.glColorMask((boolean)masking[0], (boolean)masking[1], (boolean)masking[2], (boolean)masking[3]);
        }
    }

    public static void translated(IVector2 v) {
        GL.translated(v.Xd(), v.Yd());
    }

    public static void translated(double x, double y) {
        GL11.glTranslated((double)x, (double)y, (double)0.0);
    }

    public static void bind(Color c) {
        if (c.equals(boundColor)) {
            return;
        }
        boundColor = c;
        boundColor.bind();
    }

    public static void bind(Texture tex) {
        if (tex == null) {
            GL.unbindTexture();
            return;
        }
        if (boundTexture != null && boundTexture.getID() == tex.getID()) {
            return;
        }
        if (boundTexture == null) {
            GL11.glEnable((int)3553);
        }
        GL11.glBindTexture((int)3553, (int)tex.getID());
        if (boundShader != null) {
            boundShader.handleTexturing(true);
        }
        boundTexture = tex;
        ++Debug.current.bindTexture;
    }

    public static void bind(Surface sur) {
        if (sur == null) {
            GL.unbindSurface();
            return;
        }
        if (boundSurface != null && boundSurface.getID() == sur.getID()) {
            return;
        }
        GL.unbindTexture();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sur.getID());
        GL.initDisplay(sur.image.getTextureWidth(), sur.image.getTextureHeight(), false);
        GL.enterOrtho(sur.image.getTextureWidth(), sur.image.getTextureHeight(), false);
        boundSurface = sur;
        ++Debug.current.bindSurface;
    }

    public static void bind(Shader sdr) {
        if (sdr == null) {
            GL.unbindShader();
            return;
        }
        if (boundShader != null && boundShader.getID() == sdr.getID()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)sdr.getID());
        boundShader = sdr;
        boundShader.handleTexturing(boundTexture != null);
        ++Debug.current.bindShader;
    }

    public static void unbindTexture() {
        if (boundTexture == null) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glDisable((int)3553);
        if (boundShader != null) {
            boundShader.handleTexturing(false);
        }
        boundTexture = null;
        ++Debug.current.bindTexture;
    }

    public static void unbindSurface() {
        if (boundSurface == null) {
            return;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        GL.initDisplay(Gamelib.cachedDisplayMode.getWidth(), Gamelib.cachedDisplayMode.getHeight(), false);
        GL.enterOrtho(Gamelib.cachedDisplayMode.getWidth(), Gamelib.cachedDisplayMode.getHeight());
        boundSurface = null;
        ++Debug.current.bindSurface;
    }

    public static void unbindShader() {
        if (boundShader == null) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        boundShader = null;
        ++Debug.current.bindShader;
    }

    public static void unbind() {
        if (boundShader != null) {
            GL.unbindShader();
        }
        if (boundTexture != null) {
            GL.unbindTexture();
        }
        if (boundSurface != null) {
            GL.unbindSurface();
        }
    }

    public static Texture boundTexture() {
        return boundTexture;
    }

    public static Surface boundSurface() {
        return boundSurface;
    }

    public static Shader boundShader() {
        return boundShader;
    }

    public static void setThickness(float thickness) {
        GL11.glLineWidth((float)thickness);
        GL.thickness = thickness;
    }

    public static float getThickness() {
        return thickness;
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
        ++pushed;
    }

    public static void popMatrix() {
        if (pushed == 0) {
            return;
        }
        GL11.glPopMatrix();
        --pushed;
    }

    public static boolean pushedMatrix() {
        return pushed > 0;
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
        pushed = 0;
    }
}

