/*
 * Decompiled with CFR 0.152.
 */
package pl.shockah.glib.geom.vector;

import pl.shockah.Math2;
import pl.shockah.glib.animfx.IInterpolatable;
import pl.shockah.glib.animfx.Interpolate;
import pl.shockah.glib.geom.vector.IVector2;
import pl.shockah.glib.geom.vector.Vector2d;
import pl.shockah.glib.geom.vector.Vector2f;

public class Vector2i
implements IInterpolatable<Vector2i>,
IVector2 {
    public int x;
    public int y;

    public static Vector2i make(int dist, int angle) {
        return new Vector2i((int)Math2.ldirX(dist, angle), (int)Math2.ldirY(dist, angle));
    }

    public Vector2i() {
        this(0, 0);
    }

    public Vector2i(Vector2i v) {
        this(v.x, v.y);
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector2i)) {
            return false;
        }
        Vector2i v = (Vector2i)o;
        return this.x == v.x && this.y == v.y;
    }

    public String toString() {
        return "[Vector2i: " + this.x + ", " + this.y + "]";
    }

    @Override
    public double Xd() {
        return this.x;
    }

    @Override
    public float Xf() {
        return this.x;
    }

    @Override
    public int Xi() {
        return this.x;
    }

    @Override
    public double Yd() {
        return this.y;
    }

    @Override
    public float Yf() {
        return this.y;
    }

    @Override
    public int Yi() {
        return this.y;
    }

    @Override
    public Vector2i copyMe() {
        return new Vector2i(this);
    }

    @Override
    public Vector2i toInt() {
        return this.copyMe();
    }

    @Override
    public Vector2f toFloat() {
        return new Vector2f(this.x, this.y);
    }

    @Override
    public Vector2d toDouble() {
        return new Vector2d(this.x, this.y);
    }

    public Vector2i set(IVector2 v) {
        return this.set(v.Xi(), v.Yi());
    }

    public Vector2i set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2i setX(IVector2 v) {
        return this.setX(v.Xi());
    }

    public Vector2i setX(int x) {
        this.x = x;
        return this;
    }

    public Vector2i setY(IVector2 v) {
        return this.setY(v.Yi());
    }

    public Vector2i setY(int y) {
        this.y = y;
        return this;
    }

    public Vector2i justX() {
        this.y = 0;
        return this;
    }

    public Vector2i JustX() {
        return new Vector2i(this.x, 0);
    }

    public Vector2i justY() {
        this.x = 0;
        return this;
    }

    public Vector2i JustY() {
        return new Vector2i(0, this.y);
    }

    public Vector2i negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2i Negate() {
        return new Vector2i(-this.x, -this.y);
    }

    public Vector2i abs() {
        if (this.x < 0) {
            this.x = -this.x;
        }
        if (this.y < 0) {
            this.y = -this.y;
        }
        return this;
    }

    public Vector2i Abs() {
        return new Vector2i(this.x >= 0 ? this.x : -this.x, this.y >= 0 ? this.y : -this.y);
    }

    public Vector2i add(IVector2 v) {
        return this.add(v.Xi(), v.Yi());
    }

    public Vector2i Add(IVector2 v) {
        return this.Add(v.Xi(), v.Yi());
    }

    public Vector2i add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2i Add(int x, int y) {
        return new Vector2i(this.x + x, this.y + y);
    }

    public Vector2i sub(int x, int y) {
        return this.add(-x, -y);
    }

    public Vector2i Sub(int x, int y) {
        return this.Add(-x, -y);
    }

    public Vector2i sub(IVector2 v) {
        return this.sub(v.Xi(), v.Yi());
    }

    public Vector2i Sub(IVector2 v) {
        return this.Sub(v.Xi(), v.Yi());
    }

    public Vector2i scale(int scale) {
        return this.scale(scale, scale);
    }

    public Vector2i Scale(int scale) {
        return this.Scale(scale, scale);
    }

    public Vector2i scale(int scaleH, int scaleV) {
        this.x *= scaleH;
        this.y *= scaleV;
        return this;
    }

    public Vector2i Scale(int scaleH, int scaleV) {
        return new Vector2i(this.x * scaleH, this.y * scaleV);
    }

    public Vector2i scale(IVector2 v) {
        return this.scale(v.Xi(), v.Yi());
    }

    public Vector2i Scale(IVector2 v) {
        return this.Scale(v.Xi(), v.Yi());
    }

    public Vector2i div(int scale) {
        return this.div(scale, scale);
    }

    public Vector2i Div(int scale) {
        return this.Div(scale, scale);
    }

    public Vector2i div(int scaleH, int scaleV) {
        this.x /= scaleH;
        this.y /= scaleV;
        return this;
    }

    public Vector2i Div(int scaleH, int scaleV) {
        return new Vector2i(this.x / scaleH, this.y / scaleV);
    }

    public Vector2i div(IVector2 v) {
        return this.div(v.Xi(), v.Yi());
    }

    public Vector2i Div(IVector2 v) {
        return this.Div(v.Xi(), v.Yi());
    }

    public Vector2i Vector(IVector2 v) {
        return new Vector2i(v.Xi() - this.x, v.Yi() - this.y);
    }

    public int lengthSquared() {
        return (int)(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public int length() {
        return (int)Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public int distanceSquared(IVector2 v) {
        return (int)(Math.pow(v.Xi() - this.x, 2.0) + Math.pow(v.Yi() - this.y, 2.0));
    }

    public int distance(IVector2 v) {
        return (int)Math.sqrt(Math.pow(v.Xi() - this.x, 2.0) + Math.pow(v.Yi() - this.y, 2.0));
    }

    @Override
    public double direction() {
        return new Vector2i().direction(this);
    }

    @Override
    public double direction(IVector2 v) {
        return Math.toDegrees(Math.atan2(this.y - v.Yi(), v.Xi() - this.x));
    }

    @Override
    public double deltaAngle(IVector2 v) {
        return this.deltaAngle(v.direction());
    }

    @Override
    public double deltaAngle(double angle) {
        double r;
        double a = this.direction();
        while (angle <= -180.0) {
            angle += 360.0;
        }
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (a <= -180.0) {
            a += 360.0;
        }
        while (a > 180.0) {
            a -= 360.0;
        }
        return r + (double)((r = angle - a) > 180.0 ? -360 : (r < -180.0 ? 360 : 0));
    }

    @Override
    public Vector2i interpolate(Vector2i v, double d, Interpolate method) {
        return new Vector2i(method.interpolate(this.x, v.x, d), method.interpolate(this.y, v.y, d));
    }
}

