/*
 * Decompiled with CFR 0.152.
 */
package tr545ma345;

import grt45eb4.ETerget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.Log;
import tr545ma345.H4636;
import tr545ma345.T654y;

public class YERhb
extends BasicGameState {
    public static final int BELOW = -1;
    public static final int GAME = 0;
    public static final int ABOVE = 1;
    public GameContainer container = null;
    public int id = 0;
    public int width = 0;
    public int height = 0;
    private List<ETerget> entities = new ArrayList<ETerget>();
    private List<ETerget> removable = new ArrayList<ETerget>();
    private List<ETerget> addable = new ArrayList<ETerget>();
    private List<ETerget> belowCamera = new ArrayList<ETerget>();
    private List<ETerget> aboveCamera = new ArrayList<ETerget>();
    public H4636 camera;
    public int renderedEntities;
    protected Hashtable<String, int[]> commands = new Hashtable();

    public YERhb(int id) {
        this.id = id;
    }

    public YERhb(int id, GameContainer container) {
        this.id = id;
        this.container = container;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.container = container;
        if (this.width == 0) {
            this.width = container.getWidth();
        }
        if (this.height == 0) {
            this.height = container.getHeight();
        }
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        T654y.world = this;
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.renderedEntities = 0;
        for (ETerget e : this.belowCamera) {
            if (!e.visible) continue;
            this.renderEntity(e, g, container);
        }
        if (this.camera != null) {
            g.translate(-this.camera.cameraX, -this.camera.cameraY);
        }
        for (ETerget e : this.entities) {
            if (!e.visible) continue;
            if (this.camera != null) {
                if (!this.camera.contains(e)) continue;
                this.renderEntity(e, g, container);
                continue;
            }
            this.renderEntity(e, g, container);
        }
        if (T654y.ps != null) {
            T654y.ps.render();
        }
        if (T654y.debugEnabled && this.camera != null && this.camera.getMoveRect() != null) {
            g.draw(this.camera.getMoveRect());
        }
        if (this.camera != null) {
            g.translate(this.camera.cameraX, this.camera.cameraY);
        }
        for (ETerget e : this.aboveCamera) {
            if (!e.visible) continue;
            this.renderEntity(e, g, container);
        }
        T654y.render(container, game, g);
    }

    private void renderEntity(ETerget e, Graphics g, GameContainer container) throws SlickException {
        ++this.renderedEntities;
        if (T654y.debugEnabled && e.collidable) {
            g.setColor(T654y.borderColor);
            Rectangle hitBox = new Rectangle(e.x + e.hitboxOffsetX, e.y + e.hitboxOffsetY, e.hitboxWidth, e.hitboxHeight);
            g.draw(hitBox);
            g.setColor(Color.white);
        }
        e.render(container, g);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (container == null) {
            throw new SlickException("no container set");
        }
        T654y.delta = delta;
        if (this.addable.size() > 0) {
            for (ETerget entity : this.addable) {
                this.entities.add(entity);
                entity.addedToWorld();
            }
            this.addable.clear();
            Collections.sort(this.entities);
        }
        for (ETerget e : this.belowCamera) {
            e.updateAlarms(delta);
            if (!e.active) continue;
            e.update(container, delta);
        }
        for (ETerget e : this.entities) {
            e.updateAlarms(delta);
            if (e.active) {
                e.update(container, delta);
            }
            e.checkWorldBoundaries();
        }
        for (ETerget e : this.aboveCamera) {
            e.updateAlarms(delta);
            if (!e.active) continue;
            e.update(container, delta);
        }
        if (T654y.ps != null) {
            T654y.ps.update(delta);
        }
        for (ETerget entity : this.removable) {
            this.entities.remove(entity);
            this.belowCamera.remove(entity);
            this.aboveCamera.remove(entity);
            entity.removedFromWorld();
        }
        this.removable.clear();
        if (this.camera != null) {
            this.camera.update(container, delta);
        }
        T654y.update(container, game, delta);
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void add(ETerget e, int ... flags) {
        e.setWorld(this);
        if (flags.length == 1) {
            switch (flags[0]) {
                case -1: {
                    this.belowCamera.add(e);
                    break;
                }
                case 0: {
                    this.addable.add(e);
                    break;
                }
                case 1: {
                    this.aboveCamera.add(e);
                }
            }
        } else {
            this.addable.add(e);
        }
    }

    public void addAll(Collection<ETerget> e, int ... flags) {
        for (ETerget entity : e) {
            this.add(entity, flags);
        }
    }

    public List<ETerget> getEntities() {
        return this.entities;
    }

    public int getNrOfEntities(String type) {
        if (this.entities.size() > 0) {
            int number = 0;
            for (ETerget entity : this.entities) {
                if (!entity.getType().contains(type)) continue;
                ++number;
            }
            return number;
        }
        return 0;
    }

    public List<ETerget> getEntities(String type) {
        if (this.entities.size() > 0) {
            ArrayList<ETerget> res = new ArrayList<ETerget>();
            for (ETerget entity : this.entities) {
                if (!entity.getType().contains(type)) continue;
                res.add(entity);
            }
            return res;
        }
        return null;
    }

    public boolean remove(ETerget entity) {
        if (!this.removable.contains(entity)) {
            return this.removable.add(entity);
        }
        return false;
    }

    public ETerget find(String name) {
        if (name == null) {
            return null;
        }
        for (ETerget entity : this.entities) {
            if (entity.name == null || !entity.name.equalsIgnoreCase(name)) continue;
            return entity;
        }
        for (ETerget entity : this.addable) {
            if (entity.name == null || !entity.name.equalsIgnoreCase(name)) continue;
            return entity;
        }
        for (ETerget entity : this.aboveCamera) {
            if (entity.name == null || !entity.name.equalsIgnoreCase(name)) continue;
            return entity;
        }
        for (ETerget entity : this.belowCamera) {
            if (entity.name == null || !entity.name.equalsIgnoreCase(name)) continue;
            return entity;
        }
        return null;
    }

    public void clear() {
        for (ETerget entity : this.entities) {
            entity.removedFromWorld();
        }
        this.belowCamera.clear();
        this.aboveCamera.clear();
        this.entities.clear();
        this.addable.clear();
        this.removable.clear();
    }

    public void setCamera(H4636 camera) {
        this.camera = camera;
        this.camera.setMyWorld(this);
    }

    public void setCameraOn(ETerget entity) {
        if (this.camera == null) {
            this.setCamera(new H4636(this, entity, this.container.getWidth(), this.container.getHeight()));
        }
        this.camera.setFollow(entity);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List<ETerget> findEntityWithType(String type) {
        if (type == null) {
            Log.error("Parameter must be not null");
            return null;
        }
        ArrayList<ETerget> result = new ArrayList<ETerget>();
        for (ETerget entity : this.entities) {
            if (!entity.getType().contains(type)) continue;
            result.add(entity);
        }
        return result;
    }

    public boolean isEmpty(int x, int y, int depth) {
        for (ETerget entity : this.entities) {
            Rectangle rect = new Rectangle(entity.x, entity.y, entity.width, entity.height);
            if (entity.depth != depth || !rect.contains(x, y)) continue;
            return false;
        }
        return true;
    }

    public ETerget find(int x, int y) {
        for (ETerget entity : this.entities) {
            Rectangle rect = new Rectangle(entity.x, entity.y, entity.width, entity.height);
            if (!rect.contains(x, y)) continue;
            return entity;
        }
        return null;
    }

    public int getCount() {
        return this.entities.size();
    }

    public void define(String command, int ... keys) {
        this.commands.put(command, keys);
    }

    public boolean check(String command) {
        int[] checked = this.commands.get(command);
        if (checked == null) {
            return false;
        }
        int i = 0;
        while (i < checked.length) {
            if (this.container.getInput().isKeyDown(checked[i])) {
                return true;
            }
            if (checked[i] < 10 && this.container.getInput().isMousePressed(checked[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean pressed(String command) {
        int[] checked = this.commands.get(command);
        if (checked == null) {
            return false;
        }
        int i = 0;
        while (i < checked.length) {
            if (this.container.getInput().isKeyPressed(checked[i])) {
                return true;
            }
            if ((checked[i] == 0 || checked[i] == 1) && this.container.getInput().isMousePressed(checked[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

