/*
 * Decompiled with CFR 0.152.
 */
package grt45eb4;

import grt45eb4.DASD23;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Vector2f;
import tr545ma345.T654y;
import tr545ma345.YERhb;
import tr545ma345.YRHy45356;

public abstract class ETerget
implements Comparable<ETerget> {
    public static final String SOLID = "Solid";
    public static final String PLAYER = "Player";
    public YERhb world = null;
    public String name;
    public float x;
    public float y;
    public boolean centered = false;
    public int width;
    public int height;
    public float previousx;
    public float previousy;
    public float startx;
    public float starty;
    public boolean wrapHorizontal = false;
    public boolean wrapVertical = false;
    public Vector2f speed = new Vector2f(0.0f, 0.0f);
    protected int angle = 0;
    public float scalex = 1.0f;
    public float scaley = 1.0f;
    private Color color = new Color(Color.white);
    private Hashtable<String, DASD23> alarms = new Hashtable();
    private Hashtable<String, DASD23> addableAlarms = new Hashtable();
    protected SpriteSheet sheet;
    public Hashtable<String, Animation> animations = new Hashtable();
    public String currentAnim;
    public int duration = 200;
    public int depth = -1;
    public Image currentImage;
    public Hashtable<String, int[]> commands = new Hashtable();
    private HashSet<String> type = new HashSet();
    public boolean active = true;
    public boolean collidable = true;
    public boolean visible = true;
    public float hitboxOffsetX;
    public float hitboxOffsetY;
    public int hitboxWidth;
    public int hitboxHeight;
    public YRHy45356 stateManager;

    public ETerget(float x, float y) {
        this.x = x;
        this.y = y;
        this.startx = x;
        this.starty = y;
        this.stateManager = new YRHy45356();
    }

    public ETerget(float x, float y, Image image) {
        this(x, y);
        this.setGraphic(image);
    }

    public void setCentered(boolean on) {
        int whalf = 0;
        int hhalf = 0;
        if (this.currentImage != null) {
            whalf = this.currentImage.getWidth() / 2;
            hhalf = this.currentImage.getHeight() / 2;
        }
        if (this.currentAnim != null) {
            whalf = this.animations.get(this.currentAnim).getWidth() / 2;
            hhalf = this.animations.get(this.currentAnim).getHeight() / 2;
        }
        if (on) {
            this.hitboxOffsetX -= (float)whalf;
            this.hitboxOffsetY -= (float)hhalf;
            this.centered = true;
        } else {
            if (this.centered) {
                this.hitboxOffsetX += (float)whalf;
                this.hitboxOffsetY += (float)hhalf;
            }
            this.centered = false;
        }
    }

    public void update(GameContainer container, int delta) throws SlickException {
        if (this.active) {
            this.previousx = this.x;
            this.previousy = this.y;
            if (this.stateManager != null && this.stateManager.currentState() != null) {
                this.stateManager.update(container, delta);
                return;
            }
            this.updateAnimation(delta);
            if (this.speed != null) {
                this.x += this.speed.x;
                this.y += this.speed.y;
            }
            this.checkWorldBoundaries();
            this.previousx = this.x;
            this.previousy = this.y;
        }
    }

    protected void updateAnimation(int delta) {
        Animation anim;
        if (this.animations != null && this.currentAnim != null && (anim = this.animations.get(this.currentAnim)) != null) {
            anim.update(delta);
        }
    }

    public void render(GameContainer container, Graphics g) throws SlickException {
        if (this.visible) {
            if (this.stateManager != null && this.stateManager.currentState() != null) {
                this.stateManager.render(g);
                return;
            }
            float xpos = this.x;
            float ypos = this.y;
            if (this.currentAnim != null) {
                Animation anim = this.animations.get(this.currentAnim);
                int w = anim.getWidth();
                int h = anim.getHeight();
                int whalf = w / 2;
                int hhalf = h / 2;
                if (this.centered) {
                    xpos = this.x - (float)whalf * this.scalex;
                    ypos = this.y - (float)hhalf * this.scaley;
                }
                if (this.angle != 0) {
                    g.rotate(this.x, this.y, this.angle);
                }
                anim.draw(xpos, ypos, (float)w * this.scalex, (float)h * this.scaley, this.color);
                if (this.angle != 0) {
                    g.resetTransform();
                }
            } else if (this.currentImage != null) {
                this.currentImage.setAlpha(this.color.a);
                int w = this.currentImage.getWidth() / 2;
                int h = this.currentImage.getHeight() / 2;
                if (this.centered) {
                    xpos -= (float)w;
                    ypos -= (float)h;
                    this.currentImage.setCenterOfRotation(w, h);
                } else {
                    this.currentImage.setCenterOfRotation(0.0f, 0.0f);
                }
                if (this.angle != 0) {
                    this.currentImage.setRotation(this.angle);
                }
                if (this.scalex != 1.0f || this.scaley != 1.0f) {
                    if (this.centered) {
                        g.translate(xpos - ((float)w * this.scalex - (float)w), ypos - ((float)h * this.scaley - (float)h));
                    } else {
                        g.translate(xpos, ypos);
                    }
                    g.scale(this.scalex, this.scaley);
                    g.drawImage(this.currentImage, 0.0f, 0.0f);
                } else {
                    g.drawImage(this.currentImage, xpos, ypos);
                }
                if (this.scalex != 1.0f || this.scaley != 1.0f) {
                    g.resetTransform();
                }
            }
            if (T654y.debugEnabled && this.collidable) {
                g.setColor(T654y.borderColor);
                Rectangle hitBox = new Rectangle(this.x + this.hitboxOffsetX, this.y + this.hitboxOffsetY, this.hitboxWidth, this.hitboxHeight);
                g.draw(hitBox);
                g.setColor(Color.white);
                g.drawRect(this.x, this.y, 1.0f, 1.0f);
                if (this.width != 0 && this.height != 0) {
                    float centerX = this.x + (float)(this.width / 2);
                    float centerY = this.y + (float)(this.height / 2);
                    g.setColor(Color.green);
                    g.drawRect(centerX, centerY, 1.0f, 1.0f);
                    g.setColor(Color.white);
                }
            }
        }
    }

    public void setGraphic(Image image) {
        this.currentImage = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public void setGraphic(SpriteSheet sheet) {
        this.sheet = sheet;
        this.width = sheet.getSprite(0, 0).getWidth();
        this.height = sheet.getSprite(0, 0).getHeight();
    }

    public void addAnimation(String name, boolean loop, int row, int ... frames) {
        Animation anim = new Animation(false);
        anim.setLooping(loop);
        int i = 0;
        while (i < frames.length) {
            anim.addFrame(this.sheet.getSprite(frames[i], row), this.duration);
            ++i;
        }
        if (this.animations.size() == 0) {
            this.currentAnim = name;
        }
        this.animations.put(name, anim);
    }

    public Animation addAnimation(SpriteSheet sheet, String name, boolean loop, int row, int ... frames) {
        Animation anim = new Animation(false);
        anim.setLooping(loop);
        int i = 0;
        while (i < frames.length) {
            anim.addFrame(sheet.getSprite(frames[i], row), this.duration);
            ++i;
        }
        if (this.animations.size() == 0) {
            this.currentAnim = name;
        }
        this.animations.put(name, anim);
        return anim;
    }

    public void addFlippedAnimation(String name, boolean loop, boolean fliphorizontal, boolean flipvertical, int row, int ... frames) {
        Animation anim = new Animation(false);
        anim.setLooping(loop);
        int i = 0;
        while (i < frames.length) {
            anim.addFrame(this.sheet.getSprite(frames[i], row).getFlippedCopy(fliphorizontal, flipvertical), this.duration);
            ++i;
        }
        if (this.animations.size() == 0) {
            this.currentAnim = name;
        }
        this.animations.put(name, anim);
    }

    public Animation addFlippedAnimation(SpriteSheet sheet, String name, boolean loop, boolean fliphorizontal, boolean flipvertical, int row, int ... frames) {
        Animation anim = new Animation(false);
        anim.setLooping(loop);
        int i = 0;
        while (i < frames.length) {
            anim.addFrame(sheet.getSprite(frames[i], row).getFlippedCopy(fliphorizontal, flipvertical), this.duration);
            ++i;
        }
        if (this.animations.size() == 0) {
            this.currentAnim = name;
        }
        this.animations.put(name, anim);
        return anim;
    }

    public void define(String command, int ... keys) {
        this.commands.put(command, keys);
    }

    public boolean check(String command) {
        int[] checked = this.commands.get(command);
        if (checked == null) {
            return false;
        }
        int i = 0;
        while (i < checked.length) {
            if (this.world.container.getInput().isKeyDown(checked[i])) {
                return true;
            }
            if (checked[i] < 10 && this.world.container.getInput().isMousePressed(checked[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean pressed(String command) {
        int[] checked = this.commands.get(command);
        if (checked == null) {
            return false;
        }
        int i = 0;
        while (i < checked.length) {
            if (this.world.container.getInput().isKeyPressed(checked[i])) {
                return true;
            }
            if ((checked[i] == 0 || checked[i] == 1) && this.world.container.getInput().isMousePressed(checked[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int compareTo(ETerget o) {
        if (this.depth == o.depth) {
            return 0;
        }
        if (this.depth > o.depth) {
            return 1;
        }
        return -1;
    }

    public void setHitBox(float xOffset, float yOffset, int width, int height) {
        this.setHitBox(xOffset, yOffset, width, height, true);
    }

    public void setHitBox(float xOffset, float yOffset, int width, int height, boolean collidable) {
        this.hitboxOffsetX = xOffset;
        this.hitboxOffsetY = yOffset;
        this.hitboxWidth = width;
        this.hitboxHeight = height;
        this.collidable = true;
        this.width = width;
        this.height = height;
    }

    public boolean addType(String ... types) {
        return this.type.addAll(Arrays.asList(types));
    }

    public void clearTypes() {
        this.type.clear();
    }

    public ETerget collide(String type, float x, float y) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        for (ETerget entity : this.world.getEntities()) {
            if (!entity.collidable || !entity.type.contains(type) || entity.equals(this) || !(x + this.hitboxOffsetX + (float)this.hitboxWidth > entity.x + entity.hitboxOffsetX) || !(y + this.hitboxOffsetY + (float)this.hitboxHeight > entity.y + entity.hitboxOffsetY) || !(x + this.hitboxOffsetX < entity.x + entity.hitboxOffsetX + (float)entity.hitboxWidth) || !(y + this.hitboxOffsetY < entity.y + entity.hitboxOffsetY + (float)entity.hitboxHeight)) continue;
            this.collisionResponse(entity);
            entity.collisionResponse(this);
            return entity;
        }
        return null;
    }

    public ETerget collide(String[] types, float x, float y) {
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            ETerget e = this.collide(type, x, y);
            if (e != null) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public ETerget collideWith(ETerget other, float x, float y) {
        if (other.collidable) {
            if (!other.equals(this) && x + this.hitboxOffsetX + (float)this.hitboxWidth > other.x + other.hitboxOffsetX && y + this.hitboxOffsetY + (float)this.hitboxHeight > other.y + other.hitboxOffsetY && x + this.hitboxOffsetX < other.x + other.hitboxOffsetX + (float)other.hitboxWidth && y + this.hitboxOffsetY < other.y + other.hitboxOffsetY + (float)other.hitboxHeight) {
                this.collisionResponse(other);
                other.collisionResponse(this);
                return other;
            }
            return null;
        }
        return null;
    }

    public List<ETerget> collideInto(String type, float x, float y) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        ArrayList<ETerget> collidingEntities = null;
        for (ETerget entity : this.world.getEntities()) {
            if (!entity.collidable || !entity.type.contains(type) || entity.equals(this) || !(x + this.hitboxOffsetX + (float)this.hitboxWidth > entity.x + entity.hitboxOffsetX) || !(y + this.hitboxOffsetY + (float)this.hitboxHeight > entity.y + entity.hitboxOffsetY) || !(x + this.hitboxOffsetX < entity.x + entity.hitboxOffsetX + (float)entity.hitboxWidth) || !(y + this.hitboxOffsetY < entity.y + entity.hitboxOffsetY + (float)entity.hitboxHeight)) continue;
            this.collisionResponse(entity);
            entity.collisionResponse(this);
            if (collidingEntities == null) {
                collidingEntities = new ArrayList<ETerget>();
            }
            collidingEntities.add(entity);
        }
        return collidingEntities;
    }

    public boolean collidePoint(float x, float y) {
        if (x >= this.x - this.hitboxOffsetX && y >= this.y - this.hitboxOffsetY && x < this.x - this.hitboxOffsetX + (float)this.width && y < this.y - this.hitboxOffsetY + (float)this.height) {
            this.collisionResponse(null);
            return true;
        }
        return false;
    }

    public void addedToWorld() {
    }

    public void removedFromWorld() {
    }

    public void collisionResponse(ETerget other) {
    }

    public void leftWorldBoundaries() {
    }

    public Image getCurrentImage() {
        return this.currentImage;
    }

    public void setWorld(YERhb world) {
        this.world = world;
    }

    public void checkWorldBoundaries() {
        if (this.x + (float)this.width < 0.0f) {
            this.leftWorldBoundaries();
            if (this.wrapHorizontal) {
                this.x = this.world.width + 1;
            }
        }
        if (this.x > (float)this.world.width) {
            this.leftWorldBoundaries();
            if (this.wrapHorizontal) {
                this.x = -this.width + 1;
            }
        }
        if (this.y + (float)this.height < 0.0f) {
            this.leftWorldBoundaries();
            if (this.wrapVertical) {
                this.y = this.world.height + 1;
            }
        }
        if (this.y > (float)this.world.height) {
            this.leftWorldBoundaries();
            if (this.wrapVertical) {
                this.y = -this.height + 1;
            }
        }
    }

    private String getTypes() {
        StringBuffer types = new StringBuffer();
        for (String singleType : this.type) {
            if (types.length() > 0) {
                types.append(", ");
            }
            types.append(singleType);
        }
        return types.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: " + this.name);
        sb.append(", types: " + this.getTypes());
        sb.append(", depth: " + this.depth);
        sb.append(", x: " + this.x);
        sb.append(", y: " + this.y);
        return sb.toString();
    }

    public HashSet<String> getType() {
        return this.type;
    }

    public boolean isType(String type) {
        return type.contains(type);
    }

    public void destroy() {
        this.world.remove(this);
        this.visible = false;
    }

    public int getAngleToPosition(Vector2f otherPos) {
        Vector2f diff = otherPos.sub(new Vector2f(this.x, this.y));
        return ((int)diff.getTheta() + 90) % 360;
    }

    public int getAngleDiff(int angle1, int angle2) {
        return ((angle2 - angle1) % 360 + 540) % 360 - 180;
    }

    public Vector2f getPointWithAngleAndDistance(int angle, float distance) {
        double theta = StrictMath.toRadians(angle + 90);
        float tx = (float)((double)this.x + (double)distance * StrictMath.cos(theta));
        float ty = (float)((double)this.y + (double)distance * StrictMath.sin(theta));
        Vector2f point = new Vector2f(tx, ty);
        return point;
    }

    public float getDistance(ETerget other) {
        return this.getDistance(new Vector2f(other.x, other.y));
    }

    public float getDistance(Vector2f otherPos) {
        Vector2f myPos = new Vector2f(this.x, this.y);
        return myPos.distance(otherPos);
    }

    public static Vector2f calculateVector(float angle, float magnitude) {
        Vector2f v = new Vector2f();
        v.x = (float)Math.sin(Math.toRadians(angle));
        v.x *= magnitude;
        v.y = (float)(-Math.cos(Math.toRadians(angle)));
        v.y *= magnitude;
        return v;
    }

    public static float calculateAngle(float x, float y, float x1, float y1) {
        double angle = Math.atan2(y - y1, x - x1);
        return (float)(Math.toDegrees(angle) - 90.0);
    }

    public DASD23 setAlarm(String name, int triggerTime, boolean oneShot, boolean startNow) {
        DASD23 alarm = new DASD23(name, triggerTime, oneShot);
        if (startNow) {
            alarm.start();
        }
        this.addableAlarms.put(name, alarm);
        return alarm;
    }

    public void restartAlarm(String name) {
        DASD23 alarm = this.alarms.get(name);
        if (alarm != null) {
            alarm.start();
        }
    }

    public void pauseAlarm(String name) {
        DASD23 alarm = this.alarms.get(name);
        if (alarm != null) {
            alarm.pause();
        }
    }

    public void resumeAlarm(String name) {
        DASD23 alarm = this.alarms.get(name);
        if (alarm != null) {
            alarm.resume();
        }
    }

    public void destroyAlarm(String name) {
        DASD23 alarm = this.alarms.get(name);
        if (alarm != null) {
            alarm.setDead(true);
        }
    }

    public void alarmTriggered(String name) {
    }

    public void updateAlarms(int delta) {
        if (this.visible) {
            ArrayList<String> deadAlarms = null;
            Set<String> alarmNames = this.alarms.keySet();
            if (!alarmNames.isEmpty()) {
                for (String alarmName : alarmNames) {
                    boolean retval;
                    DASD23 alarm = this.alarms.get(alarmName);
                    if (alarm.isActive() && (retval = alarm.update(delta))) {
                        this.alarmTriggered(alarm.getName());
                        if (alarm.isOneShotAlaram()) {
                            alarm.setActive(false);
                        } else {
                            alarm.start();
                        }
                    }
                    if (!alarm.isDead()) continue;
                    if (deadAlarms == null) {
                        deadAlarms = new ArrayList<String>();
                    }
                    deadAlarms.add(alarmName);
                }
                if (deadAlarms != null) {
                    for (String deadAlarm : deadAlarms) {
                        this.alarms.put(deadAlarm, null);
                    }
                }
            }
            if (this.addableAlarms != null && !this.addableAlarms.isEmpty()) {
                for (String name : this.addableAlarms.keySet()) {
                    this.alarms.put(name, this.addableAlarms.get(name));
                }
            }
            if (!this.addableAlarms.isEmpty()) {
                this.addableAlarms.clear();
            }
        }
    }

    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getAlpha() {
        return this.color.a;
    }

    public void setAlpha(float alpha) {
        if (alpha >= 0.0f && alpha <= 1.0f) {
            this.color.a = alpha;
        }
    }

    public void setPosition(Vector2f pos) {
        if (pos != null) {
            this.x = pos.x;
            this.y = pos.y;
        }
    }

    public String toCsv() {
        return (int)this.x + "," + (int)this.y + "," + this.name + "," + this.type.iterator().next();
    }

    public List<ETerget> intersect(Shape shape) {
        if (shape == null) {
            return null;
        }
        ArrayList<ETerget> result = new ArrayList<ETerget>();
        for (ETerget entity : this.world.getEntities()) {
            Rectangle rec;
            if (!entity.collidable || entity.equals(this) || !shape.intersects(rec = new Rectangle(entity.x, entity.y, entity.width, entity.height))) continue;
            result.add(entity);
        }
        return result;
    }
}

