package com.engine.layer;

import android.graphics.Rect;

import com.engine.core.Graphics;

public class SceneEnd extends Scene
{
	protected int alpha = 0;
	public float speed;
	
	public SceneEnd()
	{
		alpha = 0;
		speed = 1.0f;
	}

	@Override
	public void onStep()
	{
		alpha += 32*speed;
		if(alpha>255)
		{
			onAction();
			instanceDestroy();
		}
	}
	
	@Override
	public void onDraw(Graphics g)
	{
		g.getPaint().setARGB(alpha, 0, 0, 0);
		g.drawRect(new Rect(0, 0, g.getWidth(), g.getHeight()));
		g.getPaint().setARGB(255, 0, 0, 0);
	}
	
	@Override
	public void onAction() {}
}
