package com.engine.layer;

import java.util.ArrayList;

import android.graphics.Rect;

import com.engine.Background;
import com.engine.core.Graphics;
import com.engine.object.Object;
import com.engine.object.ObjectAlarm;

public class Layer extends ObjectAlarm
{
	protected ArrayList<Object> list = new ArrayList<Object>();
	protected ArrayList<Background> back = new ArrayList<Background>();
	protected ArrayList<Rect> collise = new ArrayList<Rect>();
	
	int count = 0;
	boolean created = false;
	
	@Override
	public void onCreate()
	{
		for(Object o : list)
		{
			o.onCreate();
			removedObject(o);
		}
		super.onCreate();
		created = true;
	}
	
	/***
	 *  Wykonuje akcje wszystkich objektw i rodzicw.
	 */
	
	@Override
	public void onStep()
	{
		for(int i = 0; i<list.size(); i++)
		{
			Object o = list.get(i);
			o.onStep();
			removedObject(o);
		}
		super.onStep();
	}
	
	/***
	 *  Wykonuje akcje wszystkich objektw i rodzicw.
	 */
	
	@Override
	public void onStep(float dtime)
	{
		for(int i = 0; i<list.size(); i++)
		{
			Object o = list.get(i);
			o.onStep(dtime);
			removedObject(o);
		}
		super.onStep(dtime);
	}
	
	/***
	 *  Rysuje warstw wraz z przypisanymi jej tami, obiektami i rodzicami.
	 * @param g Obiekt rysujcy
	 */
	
	@Override
	public void onDraw(Graphics g)
	{
		if(!isVisibled()) return;
		for(Background temp : back)
			g.drawBitmap(Background.list[temp.sprite_index], x+temp.x, y+temp.y);
		
		// sortuje objekty w warstwie
		/*
		ArrayList<Object> sort = new ArrayList<Object>();
		sort = list;
		while(true)
		{
			boolean sorted = true;
			for(int i = sort.size()-1; i>1; i--)
			{
				Object a = sort.get(i);
				Object b = sort.get(i-1);
				if(a.depth>b.depth)
				{
					sort.set(i, b);
					sort.set(i-1, a);
					sorted = false;
				}
			}
			if(sorted)
				break;
		}
		*/
		for(int i = 0; i<list.size(); i++)
		{
			Object o = list.get(i);
			if(o.isVisibled())
				o.onDraw(g, x, y);
			removedObject(o);
		}
		super.onDraw(g);
	}
	
	@Override
	public boolean onKeyDown(int key)
	{
		boolean ret = false;
		for(Object o : list)
		{
			if(o.onKeyDown(key))
				ret = true;
			removedObject(o);
		}
		if(ret)
			return true;
		return super.onKeyDown(key);
	}
	
	@Override
	public boolean onKey(int key)
	{
		for(Object o : list)
		{
			o.onKey(key);
			removedObject(o);
		}
		return super.onKey(key);
	}
	
	@Override
	public boolean onKeyUp(int key)
	{
		for(Object o : list)
		{
			o.onKeyUp(key);
			removedObject(o);
		}
		return super.onKeyUp(key);
	}
	
	@Override
	public boolean onTouchDown(int x, int y)
	{
		for(Object o : list)
		{
			if(o.onTouchDown(x, y))
			{
				removedObject(o);
				return true;
			}
		}
		return super.onTouchDown(x, y);
	}
	
	@Override
	public boolean onTouchUp(int x, int y)
	{
		for(Object o : list)
		{
			if(o.onTouchUp(x, y))
			{
				removedObject(o);
				return true;
			}
		}
		return super.onTouchUp(x, y);
	}
	
	@Override
	public boolean onTouch(int x, int y)
	{
		for(Object o : list)
		{
			if(o.onTouch(x, y))
			{
				removedObject(o);
				return true;
			}
		}
		return super.onTouch(x, y);
	}
	
	/**
	 * Usuwa wszystkie obiekty.
	 */
	
	public void clearObject()
	{
		list.clear();
	}
	
	/**
	 * Usuwa obiekt z listy.
	 * @param object obiekt
	 */
	
	public void removedObject(Object object)
	{
		if(object.removed)
		{
			object.onDestroy();
			list.remove(object);
		}
	}
	
	/**
	 * Usuwa obiekt z listy.
	 * @param id indeks obiektu
	 */
	
	public void removedObject(int id)
	{
		list.get(id).onDestroy();
		list.remove(id);
	}
	
	/**
	 * Dodaje na koniec listy nowy obiekt.
	 * @param object obiekt
	 */
	
	public void addObject(final Object object)
	{
		addObject(object, object.x, object.y);
	}
	
	/**
	 * Dodaje na koniec listy nowy obiekt.
	 * @param object obiekt
	 * @param x wsprzdna x obiektu
	 * @param y wsprzdna y obiektu
	 */
	
	public void addObject(final Object object, int x, int y)
	{
		list.add(object);
		object.x = x;
		object.y = y;
		object.xstart = x;
		object.ystart = y;
		object.parent = this;
		if(created)
			object.onCreate();
	}
	
	/**
	 * Czyci list ta
	 */
	
	public void clearBackground()
	{
		back.clear();
	}
	
	/**
	 * Dodaje to na koniec listy.
	 * @param background obiekt ta.
	 */
	
	public void addBackground(final Background background)
	{
		back.add(background);
	}
	
	/**
	 * Dodaje to na koniec listy.
	 * @param background indeks do bitmapy ta
	 * @param x wsprzdna x ta
	 * @param y wsprzdna y ta
	 */
	
	public void addBackground(int background, int x, int y)
	{
		Background b = new Background();
		b.sprite_index = background;
		b.x = x;
		b.y = y;
		back.add(b);
	}
	
	/**
	 * Dodaje now warstw.
	 * @param layer warstwa.
	 */
	
	public void addChild(final Layer layer)
	{
		if(child == null)
			child = new Layer();
		((Layer)child).addObject(layer);
		if(created)
			layer.onCreate();
	}
	
	/**
	 * Dodaje usuwa warstw.
	 * @param layer warstwa.
	 */
	
	public void removeParent(Layer layer)
	{
		if(child == null)
			((Layer)child).removedObject(layer);
	}
	
	public void addCollise(Rect rect)
	{
		collise.add(rect);
	}
	
	/**
	 * Usuwa wszystkie obiekty, ta, rodzica.
	 */
	
	public void clear()
	{
		clearObject();
		clearBackground();
		//child_lvl = null;
	}
	
	@Override
	public void onDestroy()
	{
		for(Object o : list)
			o.onDestroy();
		clear();
		//if(child_lvl != null)
			//child_lvl.onDestroy();
	}
	
	public ArrayList<Object> getInstance()
	{
		return list;
	}
	
	@Override
	public String toString()
	{
		return "Layer";
	}
}
