package com.engine.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import com.engine.Sprite;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import com.engine.core.Core;
import com.engine.core.Debug;

public abstract class Resource
{
	protected int id = 0;
	protected int state = 0;
	
	protected static ArrayList<String> sprites;
	protected static ArrayList<Integer> frame;
	protected static ArrayList<Integer> width;
	protected static ArrayList<Integer> height;
	protected static ArrayList<Integer> typ;
	static String path = "gfx";
	
	public static Bitmap GetBitmap(String file_name) throws IOException
	{
		InputStream input = Core.getInstance().getContext().
				getAssets().open(path+"/"+file_name);
		return BitmapFactory.decodeStream(input);
	}
	
	public static void setPath(String path)
	{
		Resource.path = path;
	}
	
	public static String getPath()
	{
		return path;
	}
	
	public int getState()
	{
		return state;
	}
	
	public int getCount()
	{
		return id;
	}
	
	public int getLoadingPercent()
	{
    	float state = (float) getState();
    	float delta = 100.0f/(float) getCount();
    	return ((int)(state*delta));
	}
	
	public int loadSprite(String file_name)
	{
		return loadSprite(file_name, 1);
	}
	
	public void free()
	{
		sprites.clear();
		sprites = null;
		frame.clear();
		frame = null;
		state = 0;
	}
	
	public int loadSprite(String file_name, int count)
	{
		sprites.add(file_name);
		frame.add(new Integer(count));
		typ.add(new Integer(0));
		Resource.width.add(null);
		Resource.height.add(null);
		return id++;
	}
	
	public int loadSprite(String file_name, int width, int height, int count)
	{
		sprites.add(file_name);
		frame.add(new Integer(count));
		Resource.width.add(new Integer(width));
		Resource.height.add(new Integer(height));
		typ.add(new Integer(2));
		return id++;
	}
	
	public int loadSpriteHorz(String file_name, int count)
	{
		sprites.add(file_name);
		frame.add(new Integer(count));
		typ.add(new Integer(1));
		Resource.width.add(null);
		Resource.height.add(null);
		return id++;
	}
	
	public void onLoadAll()
	{
		while(onLoad()) {}
	}
	
	public boolean onLoad()
	{
		try
		{
			if(state == 0)
			{
				Sprite.free();

				sprites = new ArrayList<String>();
				frame = new ArrayList<Integer>();
				width = new ArrayList<Integer>();
				height = new ArrayList<Integer>();
				typ = new ArrayList<Integer>();
				onInit();
				if(sprites.size() == 0)
					return true;
				Debug.inf("Sprite count:", ""+sprites.size());
				Sprite.allocate(sprites.size()+1);
			}
			int _typ = typ.get(state).intValue();
			if(_typ == 0)
				Sprite.addSprite(sprites.get(state), frame.get(state).intValue());
			else if(_typ == 1)
				Sprite.addSprite(new Sprite(sprites.get(state), frame.get(state).intValue(), true));
			else if(_typ == 2)
				Sprite.addSprite(new Sprite(sprites.get(state), width.get(state).intValue(), height.get(state).intValue(), frame.get(state).intValue()));
			state++;
			if(state > sprites.size()-1)
			{
				endLoad();
				free();
				Debug.inf("Sprite load:", "succes");
				return false;
			}
		}catch(IOException e)
		{
			e.printStackTrace();
		}
		return true;
	}
	
	public abstract void onInit();
	
	public abstract void endLoad();
}
