package com.engine.object;


import com.engine.Sprite;
import com.engine.action.Action;
import com.engine.core.Graphics;
import com.engine.layer.Layer;

/***
 *  Obiekt bazowa cz systemu
 */

public class Object extends ObjectBase
{
	/**
	 * Wsprzdna x utworzenia obiektu
	 */
	
	public int xstart;
	
	/**
	 * Wsprzdna y utworzenia obiektu
	 */
	
	public int ystart;
	
	/**
	 * Szybko rysowania animacji.
	 */
	
	public float image_speed;
	
	/**
	 * Czy obiekt stale ma by w tej samej pozycji.
	 */
	
	public boolean lock;
	
	/**
	 * pozycja klatki animacji
	 */
	
	public int image_index;
	
	public int depth;
	
	/**
	 * Rodzic
	 */
	
	protected Object child;
	
	public Object parent;
	
	/**
	 * Czy obiekt ma zosta usunity.
	 */
	
	public boolean removed;
	
	/**
	 * Czy obiekt zosta utworzony.
	 */
	
	protected boolean created;
	
	/**
	 * Czy obiekt jest widoczny.
	 */
	
	protected boolean visible;
	
	public Action []action;
	
	/**
	 * Konstruktor {@link #Object()}
	 */
	
	public Object()
	{
		created = false;
		visible = true;
		x = 0;
		y = 0;
		xstart = 0;
		ystart = 0;
		lock = false;
		image_speed = 0;
		sprite_index = -1;
		image_index = 0;
		depth = 0;
		child = null;
		removed = false;
		parent = null;
		action = new Action[5];
	}
	
	/***
	 *  Usuwa instancj obiektu
	 */
	
	public void instanceDestroy()
	{
		removed = true;
		if(child != null)
			child.instanceDestroy();
	}
	
	/***
	 *  Wykonuje akcj tylko raz po utworzeniu obiektu.
	 */
	
	public void onCreate()
	{
		if(child != null)
			child.onCreate();
		created = true;
	}
	
	/***
	 *  Wykonuje akcj co kad klatk.
	 */
	public void onStep()
	{
		for(Action a : action)
		{
			if(a != null)
				a.onStep();
		}
		
		if(child != null)
			child.onStep();
	}
	
	/***
	 *  Wykonuje akcj co kad klatk.
	 */
	public void onStep(float dtime)
	{
		onStep();
	}
	/**
	 * Sprawdz czy klawisz zosta wcinity
	 * @param key klawisz
	 * @return tak lub nie
	 */
	
	public boolean onKeyDown(int key)
	{
		if(child != null)
			child.onKeyDown(key);
		return false;
	}
	
	/**
	 * Sprawdz czy klawisz jest trzymany
	 * @param key klawisz
	 * @return tak lub nie
	 */
	
	public boolean onKey(int key)
	{
		if(child != null)
			child.onKey(key);
		return false;
	}
	
	/**
	 * Sprawdz czy klawisz zosta puszczony
	 * @param key klawisz
	 * @return tak lub nie
	 */
	
	public boolean onKeyUp(int key)
	{
		if(child != null)
			child.onKeyUp(key);
		return false;
	}
	
	/***
	 *  Sprawdza czy ekran zosta dotknity
	 *  i wykonuje akc dla niej przypisan.
	 *  @param x Wsprzdna x
	 *  @param y Wsprzdna y
	 */
	
	public boolean onTouchDown(int x, int y)
	{
		if(child != null)
			if(child.onTouchDown(x, y))
				return true;
		return false;
	}
	
	/***
	 *  Sprawdza czy ekran zosta puszczony
	 *  i wykonuje akc dla niej przypisan.
	 *  @param x Wsprzdna x
	 *  @param y Wsprzdna y
	 */
	
	public boolean onTouchUp(int x, int y)
	{
		if(child != null)
			child.onTouchUp(x, y);
		return false;
	}
	
	/***
	 *  Sprawdza czy dotykasz ekranu
	 *  i wykonuje akc dla niej przypisan.
	 *  @param x Wsprzdna x
	 *  @param y Wsprzdna y
	 */
	
	public boolean onTouch(int x, int y)
	{
		if(child != null)
			child.onTouch(x, y);
		return false;
	}
	
	/***
	 *  Rysuje Obiekt.
	 *  @param _x Wsprzdna x
	 *  @param _y Wsprzdna y
	 */
	
	public void onDraw(Graphics g, int _x, int _y)
	{
		int old_x = this.x;
		int old_y = this.y;
		this.x += _x;
		this.y += _y;
		onDraw(g);
		this.x = old_x;
		this.y = old_y;
	}
	
	/***
	 *  Rysuje Obiekt.
	 */
	
	public void onDraw(Graphics g)
	{
		if(!visible) return;
		if(sprite_index != -1)
			Sprite.draw(g, sprite_index, image_index, x, y);
		if(child != null)
			child.onDraw(g);
	}
	
	/***
	 *  Wykonuje akcj po skasowaniu obiektu.
	 */
	
	public void onDestroy()
	{
		if(child != null)
			child.onDestroy();
	}
	
	/***
	 *  Ustawia dziecko.
	 * @param parent rodzic
	 */
	
	public void setChild(Object parent)
	{
		this.child = parent;
		if(created)
			onCreate();
	}
	
	/***
	 *  Usuwa dziecko.
	 */
	
	public void removeChild()
	{
		this.child.removeChild();
		this.child = null;
	}
	
	/***
	 *  Wywietla/chowa obiekt.
	 */
	
	public void setVisibled(boolean visible)
	{
		this.visible = visible;
	}
	
	/***
	 *  Sprawdza czy obiekt jest widoczny.
	 */
	
	public boolean isVisibled()
	{
		return visible;
	}
	
	/***
	 *  Blokuje/Odblokowuje obiekt.
	 */
	
	public void setLock(boolean lock)
	{
		this.lock = lock;
	}
	
	/***
	 *  Sprawdza czy obiekt jest zablokowany.
	 */
	
	public boolean isLock()
	{
		return lock;
	}

	/***
	 *  Dodaje nowy objekt do najbliszego Layera
	 * @param obj Dodawany objekt
	 */
	
	public void instanceCreate(Object obj)
	{
		if(parent != null)
			((Layer)parent).addObject(obj);
	}
	
	@Override
	public String toString()
	{
		return "Object";
	}
}
