package com.engine.layer;

import java.util.ArrayList;

import com.engine.core.Graphics;
import com.engine.object.Object;

public class LayerManager
{
	/**
	 * Lista warstw.
	 */
	
	private final ArrayList<Object> list = new ArrayList<Object>();
	
	/***
	 * Dodaje now warstw na koniec listy.
	 * @param layer warstwa.
	 */
	
	public void addLayer(Layer layer)
	{
		list.add(layer);
	}
	
	/***
	 * Usuwa warstw z listy.
	 * @param layer warstwa.
	 */
	
	public void removeLayer(Layer layer)
	{
		list.remove(layer);
	}
	
	public void onCreate()
	{
		for(Object o : list)
		{
			o.onCreate();
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
	}
	
	public void onStep()
	{
		for(Object o : list)
		{
			o.onStep();
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
	}
	
	public void onStep(float dtime)
	{
		for(Object o : list)
		{
			o.onStep(dtime);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
	}
	
	public void onDraw(Graphics g)
	{
		for(Object o : list)
		{
			o.onDraw(g);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
	}
	
	public boolean onTouchDown(int x, int y)
	{
		boolean ret = false;
		for(Object o : list)
		{
			ret |= o.onTouchDown(x, y);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
		return ret;
	}
	
	public boolean onTouchUp(int x, int y)
	{
		boolean ret = false;
		for(Object o : list)
		{
			ret |= o.onTouchUp(x, y);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
		return ret;
	}
	
	public boolean onTouch(int x, int y)
	{
		boolean ret = false;
		for(Object o : list)
		{
			ret |= o.onTouch(x, y);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
		return ret;
	}
	
	public boolean onKeyDown(int key)
	{
		boolean ret = false;
		for(Object o : list)
		{
			ret |= o.onKeyDown(key);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
		return ret;
	}
	
	public boolean onKeyUp(int key)
	{
		boolean ret = false;
		for(Object o : list)
		{
			ret |= o.onKeyUp(key);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
		return ret;
	}
	
	public boolean onKey(int key)
	{
		boolean ret = false;
		for(Object o : list)
		{
			ret |= o.onKey(key);
			if(o.removed)
			{
				o.onDestroy();
				list.remove(o);
			}
		}
		return ret;
	}
	
	public ArrayList<Object> getInstance()
	{
		return list;
	}
	
	public void onDestroy()
	{
		for(Object o : list)
			o.onDestroy();
	}
}
