package com.engine;

import com.engine.core.Core;
import com.engine.core.Debug;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class EngineSurface extends SurfaceView implements SurfaceHolder.Callback
{
    public EngineSurface(Context context, AttributeSet attrs) 
    {
        super(context, attrs);
        SurfaceHolder holder = getHolder();
        holder.addCallback(this);

        // Enable key events notifications.
        setFocusable(true);
    }

    @Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width, int height)
    {
        Debug.inf(getClass().getName(), "surfaceChanged");
        Core.getInstance().screenChanged(holder, width, height);
    }

    @Override
	public void surfaceCreated(SurfaceHolder holder) 
    {
        Debug.inf(getClass().getName(), "surfaceCreated");
        Core.getInstance().screenCreated(holder);
    }

    @Override
	public void surfaceDestroyed(SurfaceHolder holder) 
    {
        Debug.inf(getClass().getName(), "surfaceDestroyed");
        Core.getInstance().screenDestroyed(holder);
    }

    /**
     * Standard override to get key-press events.
     */
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent msg) 
    {
        return Core.getInstance().keyDown(keyCode, msg);
    }

    /**
     * Standard override for key-up.
     */
    @Override
    public boolean onKeyUp(int keyCode, KeyEvent msg) 
    {
        return Core.getInstance().keyUp(keyCode, msg);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) 
    {
        return Core.getInstance().touchEvent(event);
    }

    /**
     * Standard window-focus override. Notice focus lost so we can pause on
     * focus lost. e.g. user switches to take a call.
     */
    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) 
    {
        Core.getInstance().focusChanged(hasWindowFocus);
    }
}
